/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;

public class ExtractModules4OntologyEntities {
    private OWLOntologyManager externalOntologyManager;
    private OWLOntology ontoToModularize;
    private IRI extOntoIRI = IRI.create((String)"http://krono.act.uji.es/Links/ontologies/JIA-1.owl");
    private static final String defaultModuleIRI = "http://krono.act.uji.es/Links/ontologies/module_";
    private OWLOntology module;
    private IRI physicalModuleIRI;
    private IRI moduleIRI;
    private ModuleExtractor extractor;

    public ExtractModules4OntologyEntities() {
        this.loadExternalOntology();
        this.initExtractor();
        for (OWLEntity ent : this.ontoToModularize.getSignature()) {
            Set<OWLAxiom> Axioms = this.extractor.extractModuleAxiomsForEntity(ent);
            this.moduleIRI = IRI.create((String)(defaultModuleIRI + this.getEntityLabel(ent.getIRI().toString()) + ".owl"));
            this.module = this.extractor.getModuleFromAxioms(Axioms, this.moduleIRI);
            this.physicalModuleIRI = IRI.create((String)("file:/c://modules/" + this.getEntityLabel(ent.getIRI().toString()) + ".owl"));
            this.saveModuleToPhysicalIRI();
        }
    }

    private boolean loadExternalOntology() {
        this.externalOntologyManager = OWLManager.createOWLOntologyManager();
        try {
            this.ontoToModularize = this.externalOntologyManager.loadOntology(this.extOntoIRI);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading ontology form URI: " + this.extOntoIRI.toString());
            e.printStackTrace();
            this.ontoToModularize = null;
            return false;
        }
    }

    private void saveModuleToPhysicalIRI() {
        try {
            this.externalOntologyManager.saveOntology(this.module, (OWLOntologyFormat)new RDFXMLOntologyFormat(), this.physicalModuleIRI);
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void initExtractor() {
        boolean dualConcepts = false;
        boolean dualRoles = false;
        this.extractor = new ModuleExtractor(this.ontoToModularize, dualConcepts, dualRoles);
    }

    private String getEntityLabel(String iriStr) {
        if (iriStr.indexOf("#") >= 0) {
            return iriStr.split("#")[1];
        }
        return iriStr;
    }

    public static void main(String[] args) {
        new ExtractModules4OntologyEntities();
    }
}

