/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import uk.ac.manchester.syntactic_locality.SyntacticLocalityChecker;

public class ModuleExtractor {
    private OWLEntityCollector axiomSignatureCollector;
    private HashSet<OWLAxiom> ontologyAxioms;
    private OWLOntologyManager ontologyManager;
    private SyntacticLocalityChecker localityChecker;
    private boolean considerAnnotations = false;
    private boolean considerImportsClosure = true;
    private boolean ignoreAssertions = false;
    private Set<OWLEntity> collectedEntities;
    private OWLDataFactory dataFactory;
    private Set<OWLAxiom> moduleAxioms;
    private Set<OWLEntity> moduleSignature = new HashSet<OWLEntity>();
    private List<OWLEntity> newMembers = new ArrayList<OWLEntity>();

    public ModuleExtractor(OWLOntology ontology, boolean dualConcepts, boolean dualRoles, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.ontologyAxioms = new HashSet();
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.collectedEntities = new HashSet<OWLEntity>();
        this.axiomSignatureCollector = new OWLEntityCollector(this.collectedEntities);
        this.axiomSignatureCollector.setCollectDatatypes(false);
        this.considerAnnotations = considerEntityAnnotations;
        this.considerImportsClosure = considerImportsClosure;
        this.ignoreAssertions = ignoreAssertions;
        this.indexOntology(ontology);
        this.setLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions);
    }

    public ModuleExtractor(OWLOntology ontology, boolean dualConcepts, boolean dualRoles) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.ontologyAxioms = new HashSet();
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.collectedEntities = new HashSet<OWLEntity>();
        this.axiomSignatureCollector = new OWLEntityCollector(this.collectedEntities);
        this.axiomSignatureCollector.setCollectDatatypes(false);
        this.indexOntology(ontology);
        this.setLocalityChecker(dualConcepts, dualRoles, false, true);
    }

    /*
     * Unable to fully structure code
     */
    private void indexOntology(OWLOntology ontology) {
        block5: {
            if (this.considerImportsClosure) {
                try {
                    this.indexImportedOntologies(this.ontologyManager.getImportsClosure(ontology));
                    break block5;
                }
                catch (Exception e) {
                    ** for (ax : ontology.getAxioms())
                }
lbl-1000:
                // 1 sources

                {
                    if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                    this.ontologyAxioms.add(ax);
                    continue;
lbl11:
                    // 1 sources

                    break block5;
                }
            }
            for (OWLAxiom ax : ontology.getAxioms()) {
                if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                this.ontologyAxioms.add(ax);
            }
        }
    }

    private void indexImportedOntologies(Set<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            for (OWLAxiom ax : ontology.getAxioms()) {
                if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                this.ontologyAxioms.add(ax);
            }
        }
    }

    private void setLocalityChecker(boolean dualConcepts, boolean dualRoles, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.localityChecker = new SyntacticLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions);
    }

    private Set<OWLEntity> getAxiomSignature(OWLAxiom ax) {
        this.collectedEntities.clear();
        this.axiomSignatureCollector.reset(this.collectedEntities);
        ax.accept((OWLObjectVisitor)this.axiomSignatureCollector);
        return this.collectedEntities;
    }

    public OWLOntology getLocalityModuleForSignatureGroup(Set<OWLEntity> signature) {
        return this.getLocalityModuleForSignatureGroup(signature, "http://krono.ac.uji.es/Links/ontologies/module" + new UID() + ".owl");
    }

    public OWLOntology getLocalityModuleForSignatureGroup(Set<OWLEntity> signature, String moduleURIStr) {
        long init = Calendar.getInstance().getTimeInMillis();
        this.moduleAxioms.clear();
        IRI moduleIRI = IRI.create((String)moduleURIStr.replace("\\", "//"));
        this.extractModuleAxiomsForGroupSignature(signature);
        long fin = Calendar.getInstance().getTimeInMillis();
        return this.getModuleFromAxioms(this.moduleAxioms, moduleIRI);
    }

    public OWLOntology getModuleFromAxioms(Set<OWLAxiom> moduleAxioms, IRI moduleIri) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        long init = Calendar.getInstance().getTimeInMillis();
        OWLOntology module = null;
        try {
            module = this.ontologyManager.createOntology(moduleIri);
            ArrayList<AddAxiom> ontoChanges = new ArrayList<AddAxiom>();
            for (OWLAxiom axiom : moduleAxioms) {
                ontoChanges.add(new AddAxiom(module, axiom));
            }
            this.ontologyManager.applyChanges(ontoChanges);
        }
        catch (Exception e) {
            System.out.println("Error creating module ontology from axioms.");
        }
        long fin = Calendar.getInstance().getTimeInMillis();
        return module;
    }

    public Set<OWLAxiom> extractModuleAxiomsForGroupSignature(Set<OWLEntity> signature) {
        this.moduleSignature = signature;
        int previousSize = 0;
        for (OWLEntity ent : this.moduleSignature) {
            this.moduleAxioms.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(ent));
        }
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                this.moduleAxioms.add(ax);
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleAxioms;
    }

    public Set<OWLEntity> extractModuleEntitiesForGroupSignature(Set<OWLEntity> signature) {
        this.moduleSignature = signature;
        int previousSize = 0;
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleSignature;
    }

    public Set<OWLEntity> extractModuleEntitiesForEntity(OWLEntity entity) {
        this.moduleSignature.clear();
        this.moduleSignature.add(entity);
        int previousSize = 0;
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleSignature;
    }

    public Set<OWLAxiom> extractModuleAxiomsForEntity(OWLEntity entity) {
        this.moduleSignature.clear();
        this.moduleSignature.add(entity);
        int previousSize = 0;
        for (OWLEntity ent : this.moduleSignature) {
            this.moduleAxioms.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(ent));
        }
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                this.moduleAxioms.add(ax);
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleAxioms;
    }

    private OWLClass Thing() {
        return this.ontologyManager.getOWLDataFactory().getOWLThing();
    }
}

