/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;

public class ModuleExtractorManager {
    public static final String LOWER_MODULE = "LOWER_MODULE";
    public static final String LM = "LM";
    public static final String UPPER_MODULE = "UPPER_MODULE";
    public static final String UM = "UM";
    public static final String LOWER_UPPER_MODULE = "LOWER_UPPER_MODULE";
    public static final String LUM = "LUM";
    public static final String UPPER_LOWER_MODULE = "UPPER_LOWER_MODULE";
    public static final String ULM = "ULM";
    public static final String DUAL_CONCEPTS_MODULE = "DUAL_CONCEPTS_MODULE";
    public static final String DCM = "DCM";
    public static final String DUAL_ROLES_MODULE = "DUAL_ROLES_MODULE";
    public static final String DRM = "DRM";
    private boolean dualConcepts;
    private boolean dualRoles;
    private boolean secondIteration;
    private Set<OWLEntity> foreignSignature1;
    private Set<OWLEntity> foreignSignature2;
    private ModuleExtractor modularizer_Iteration1;
    private ModuleExtractor modularizer_Iteration2;
    private OWLOntology ontoToModularize;
    private OWLOntology module;
    private boolean considerAnnotations = false;
    private boolean considerImportsClosure = true;

    public ModuleExtractorManager(OWLOntology ontology, String ModuleType) {
        this(ontology, ModuleType, true, false, false);
    }

    public ModuleExtractorManager(OWLOntology ontology, String ModuleType, boolean considerImportsClosure, boolean considerAnnotations, boolean ignoreAnnotations) {
        this.ontoToModularize = ontology;
        this.getModuleType(ModuleType);
        this.considerAnnotations = considerAnnotations;
        this.considerImportsClosure = considerImportsClosure;
        this.modularizer_Iteration1 = new ModuleExtractor(this.ontoToModularize, this.dualConcepts, this.dualRoles, considerImportsClosure, considerAnnotations, ignoreAnnotations);
    }

    public OWLOntology getModuleFromAxioms(Set<OWLAxiom> moduleAxioms, IRI moduleIri) {
        OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
        OWLOntology module = null;
        try {
            module = ontologyManager.createOntology(moduleIri);
            ArrayList<AddAxiom> ontoChanges = new ArrayList<AddAxiom>();
            for (OWLAxiom axiom : moduleAxioms) {
                ontoChanges.add(new AddAxiom(module, axiom));
            }
            ontologyManager.applyChanges(ontoChanges);
        }
        catch (Exception e) {
            System.out.println("Error creating module ontology from extende set of axioms.");
        }
        return module;
    }

    private void getModuleType(String ModuleType) {
        if (ModuleType.equals(UPPER_MODULE) || ModuleType.equals(UM)) {
            this.dualConcepts = false;
            this.dualRoles = false;
            this.secondIteration = false;
        } else if (ModuleType.equals(LOWER_MODULE) || ModuleType.equals(LM)) {
            this.dualConcepts = true;
            this.dualRoles = true;
            this.secondIteration = false;
        } else if (ModuleType.equals(LOWER_UPPER_MODULE) || ModuleType.equals(LUM)) {
            this.dualConcepts = false;
            this.dualRoles = false;
            this.secondIteration = true;
        } else if (ModuleType.equals(UPPER_LOWER_MODULE) || ModuleType.equals(ULM)) {
            this.dualConcepts = true;
            this.dualRoles = true;
            this.secondIteration = true;
        } else if (ModuleType.equals(DUAL_CONCEPTS_MODULE) || ModuleType.equals(DCM)) {
            this.dualConcepts = true;
            this.dualRoles = false;
            this.secondIteration = false;
        } else if (ModuleType.equals(DUAL_ROLES_MODULE) || ModuleType.equals(DRM)) {
            this.dualConcepts = false;
            this.dualRoles = true;
            this.secondIteration = false;
        } else {
            System.err.println("The given module type is unknown. An Upper Module will be extracted.");
            this.dualConcepts = false;
            this.dualRoles = false;
            this.secondIteration = false;
        }
    }

    public OWLOntology extractModule(HashSet<OWLEntity> signature) {
        return this.extractModule(signature, "http://krono.ac.uji.es/Links/ontologies/module" + new UID() + ".owl");
    }

    public OWLOntology extractModule(HashSet<OWLEntity> signature, String moduleURIStr) {
        if (this.secondIteration) {
            this.foreignSignature1 = new HashSet<OWLEntity>(signature);
            this.foreignSignature2 = new HashSet<OWLEntity>(signature);
            String auxModuleURI = "http://krono.act.uji.es/Links/ontologies/temporalModule.owl";
            this.module = this.modularizer_Iteration1.getLocalityModuleForSignatureGroup(this.foreignSignature1, auxModuleURI);
            System.out.println("Module size (axioms) Iter 1: " + this.module.getAxioms().size());
            if (this.module.getAxioms().size() == 0 && this.module.getClassesInSignature().size() == 0) {
                System.out.println("(Empty module, so not necessary iteration) Module size (axioms) Iter 2: " + this.module.getAxioms().size());
            } else {
                this.modularizer_Iteration2 = new ModuleExtractor(this.module, !this.dualConcepts, !this.dualRoles, this.considerImportsClosure, this.considerAnnotations, false);
                this.module = this.modularizer_Iteration2.getLocalityModuleForSignatureGroup(this.foreignSignature2, moduleURIStr);
                System.out.println("Module size (axioms) Iter 2: " + this.module.getAxioms().size());
            }
        } else {
            this.foreignSignature1 = new HashSet<OWLEntity>(signature);
            this.module = this.modularizer_Iteration1.getLocalityModuleForSignatureGroup(this.foreignSignature1, moduleURIStr);
        }
        return this.module;
    }

    public IRI getModuleIRI() {
        return this.module.getOntologyID().getOntologyIRI();
    }

    public OWLOntology getExtractedModule() {
        return this.module;
    }

    public Set<OWLAxiom> getModuleAxioms() {
        return this.module.getAxioms();
    }

    public int getNumberOfAxiomsExtractedModule() {
        return this.module.getAxioms().size();
    }

    public int getNumberOfClassesExtractedModule() {
        return this.module.getClassesInSignature().size();
    }

    public int getNumberOfIndividualsExtractedModule() {
        return this.module.getIndividualsInSignature().size();
    }

    public int getNumberOfRolesExtractedModule() {
        return this.module.getDataPropertiesInSignature().size() + this.module.getObjectPropertiesInSignature().size();
    }

    public int getNumberOfAxiomsOntoToModularize() {
        return this.ontoToModularize.getAxioms().size();
    }

    public int getNumberOfClassesOntoToModularize() {
        return this.ontoToModularize.getClassesInSignature().size();
    }

    public int getNumberOfIndividualsOntoToModularize() {
        return this.ontoToModularize.getIndividualsInSignature().size();
    }

    public int getNumberOfRolesOntoToModularize() {
        return this.ontoToModularize.getDataPropertiesInSignature().size() + this.ontoToModularize.getObjectPropertiesInSignature().size();
    }
}

