/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class SyntacticLocalityChecker
implements OWLAxiomVisitor {
    private boolean local;
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private String suggestedInformation;
    private PositiveOWLClassExpressionVisitor positiveOWLClassExpressionChecker;
    private NegativeOWLClassExpressionVisitor negativeOWLClassExpressionChecker;
    private Set<OWLEntity> foreignSignature;
    private boolean dualRoles;
    private boolean dualConcepts;
    private boolean considerEntityAnnotations;
    private boolean ignoreAssertions;

    public SyntacticLocalityChecker(boolean dualClasses, boolean dualProperties, boolean considerAnnotations, boolean ignoreAssertions) {
        this.dualConcepts = dualClasses;
        this.dualRoles = dualProperties;
        this.considerEntityAnnotations = considerAnnotations;
        this.ignoreAssertions = ignoreAssertions;
        this.positiveOWLClassExpressionChecker = new PositiveOWLClassExpressionVisitor();
        this.negativeOWLClassExpressionChecker = new NegativeOWLClassExpressionVisitor();
    }

    public SyntacticLocalityChecker(boolean dualClasses, boolean dualProperties) {
        this(dualClasses, dualProperties, false, false);
    }

    public String suggestions() {
        return this.suggestedInformation;
    }

    public boolean isLocalAxiom(OWLAxiom axiom, Set<OWLEntity> signature) {
        this.foreignSignature = signature;
        axiom.accept((OWLAxiomVisitor)this);
        return this.local;
    }

    private OWLClass Nothing() {
        return this.manager.getOWLDataFactory().getOWLNothing();
    }

    private OWLClass Thing() {
        return this.manager.getOWLDataFactory().getOWLThing();
    }

    private boolean isNegativeOWLClassExpression(OWLClassExpression classDescription) {
        classDescription.accept((OWLClassExpressionVisitor)this.negativeOWLClassExpressionChecker);
        return this.negativeOWLClassExpressionChecker.isNegativeDescription();
    }

    private boolean isPositiveOWLClassExpression(OWLClassExpression classDescription) {
        classDescription.accept((OWLClassExpressionVisitor)this.positiveOWLClassExpressionChecker);
        return this.positiveOWLClassExpressionChecker.isPositiveDescription();
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.local = this.ignoreAssertions || this.isPositiveOWLClassExpression(axiom.getClassExpression());
        this.suggestedInformation = "An OWLClassAssertionAxiom is local (bottom or dual) if the class description is 'Positive', considering foreign entities both top and bottom.";
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.local = this.ignoreAssertions;
        this.suggestedInformation = "An OWLNegativeDataPropertyAssertionAxiom is always non-local.";
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.local = this.ignoreAssertions;
        this.suggestedInformation = "An OWLNegativeObjectPropertyAssertionAxiom is always non-local.";
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.local = this.ignoreAssertions || this.dualRoles && !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "An OWLObjectPropertyAssertionAxiom could be dual-local if the property doesn't belong to the external signature";
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.local = this.ignoreAssertions || this.dualRoles && !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        this.suggestedInformation = "An OWLDataPropertyAssertionAxiom could be dual-local if the property doesn't belong to the external signature";
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.local = this.ignoreAssertions;
        this.suggestedInformation = "An OWLSameIndividualsAxiom is always non-local.";
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.local = this.ignoreAssertions;
        this.suggestedInformation = "An OWLDifferentIndividualsAxiom is always non-local.";
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.local = this.isNegativeOWLClassExpression(axiom.getSubClass()) || this.isPositiveOWLClassExpression(axiom.getSuperClass());
        this.suggestedInformation = "An OWLSubClassAxiom is local if 'the subclass description is Negative' or 'the superclass description is Positive'.";
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.suggestedInformation = "An OWLDisjointClassesAxiom is local if at least one of the involved descriptions isNegative.";
        Set disjclasses = axiom.getClassExpressions();
        if (disjclasses.size() <= 1) {
            this.local = true;
            return;
        }
        for (OWLClassExpression clsDesc : disjclasses) {
            if (!this.isNegativeOWLClassExpression(clsDesc)) continue;
            this.local = true;
            return;
        }
        this.local = false;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set eqclasses = axiom.getClassExpressions();
        if (eqclasses.size() == 1) {
            this.local = true;
        } else if (eqclasses.size() == 2) {
            Iterator iter = eqclasses.iterator();
            OWLClassExpression first = (OWLClassExpression)iter.next();
            OWLClassExpression second = (OWLClassExpression)iter.next();
            this.local = (this.isNegativeOWLClassExpression(first) || this.isPositiveOWLClassExpression(second)) && (this.isNegativeOWLClassExpression(second) || this.isPositiveOWLClassExpression(first));
        } else {
            Object[] classDescriptions = eqclasses.toArray();
            int i = 0;
            while (i < classDescriptions.length - 1) {
                int j = i + 1;
                while (j < classDescriptions.length) {
                    boolean bl = this.local = !(!this.isNegativeOWLClassExpression((OWLClassExpression)classDescriptions[i]) && !this.isPositiveOWLClassExpression((OWLClassExpression)classDescriptions[j]) || !this.isNegativeOWLClassExpression((OWLClassExpression)classDescriptions[j]) && !this.isPositiveOWLClassExpression((OWLClassExpression)classDescriptions[i]));
                    if (!this.local) {
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.suggestedInformation = "An OWLEquivalentClassesAxiom is local if both sides of the axiom have the same value, or Negative or Positive. It could be also considered as a combined subClassOf axiom.";
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.suggestedInformation = "We should guarantee the locality both for the equivalence and for the disjointness.";
        OWLObjectUnionOf unionDesc = this.manager.getOWLDataFactory().getOWLObjectUnionOf(axiom.getClassExpressions());
        if (!this.isNegativeOWLClassExpression((OWLClassExpression)axiom.getOWLClass()) && !this.isPositiveOWLClassExpression((OWLClassExpression)unionDesc) || !this.isNegativeOWLClassExpression((OWLClassExpression)unionDesc) && !this.isPositiveOWLClassExpression((OWLClassExpression)axiom.getOWLClass())) {
            this.local = false;
            return;
        }
        this.local = true;
        for (OWLClassExpression clsDesc : axiom.getClassExpressions()) {
            if (!this.isNegativeOWLClassExpression(clsDesc)) continue;
            this.local = true;
            return;
        }
        this.local = false;
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.local = !this.dualRoles && !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()) ? true : this.dualRoles && !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty());
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.local = !this.dualRoles && !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()) ? true : this.dualRoles && !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.suggestedInformation = "An OWLEquivalentDataPropertiesAxiom is local if non external properties are involved.";
        for (OWLDataPropertyExpression dataPropExp : axiom.getProperties()) {
            if (!this.foreignSignature.contains(dataPropExp.asOWLDataProperty())) continue;
            this.local = false;
            return;
        }
        this.local = true;
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.suggestedInformation = "An OWLEquivalentObjectPropertiesAxiom is local if non external properties are involved.";
        for (OWLObjectPropertyExpression dataPropExp : axiom.getProperties()) {
            if (!this.foreignSignature.contains(dataPropExp.asOWLObjectProperty())) continue;
            this.local = false;
            return;
        }
        this.local = true;
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.local = false;
        this.suggestedInformation = "An OWLDisjointDataPropertiesAxiom is always non local.";
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.local = false;
        this.suggestedInformation = "An OWLDisjointObjectPropertiesAxiom is always non local.";
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) && !this.dualRoles;
        this.suggestedInformation = "A OWLFunctionalDataPropertyAxiom axiom can only be bottom local iff property does not belong to the external signature.";
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()) && !this.dualRoles;
        this.suggestedInformation = "A OWLFunctionalObjectPropertyAxiom axiom can only be bottom local iff property does not belong to the external signature.";
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()) && !this.dualRoles;
        this.suggestedInformation = "A OWLInverseFunctionalObjectPropertyAxiom axiom can only be bottom local iff property does not belong to the external signature.";
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.local = !this.foreignSignature.contains(axiom.getFirstProperty().asOWLObjectProperty()) && !this.foreignSignature.contains(axiom.getSecondProperty().asOWLObjectProperty());
        this.suggestedInformation = "A OWLInverseObjectPropertiesAxiom axiom is local iff the involved property do not belong to the external signature.";
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "A OWLIrreflexiveObjectPropertyAxiom axiom is local iff property does not belong to the external signature.";
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "A OWLAntiSymmetricObjectPropertyAxiom axiom is local iff property does not belong to the external signature.";
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "A OWLSymmetricObjectPropertyAxiom axiom is local iff property does not belong to the external signature.";
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "A OWLSymmetricObjectPropertyAxiom axiom is local iff property does not belong to the external signature.";
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        this.suggestedInformation = "A OWLFunctionalObjectPropertyAxiom axiom is local iff property does not belong to the external signature.";
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.local = this.isPositiveOWLClassExpression(axiom.getDomain()) ? true : !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) && !this.dualRoles;
        this.suggestedInformation = "";
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.local = this.isPositiveOWLClassExpression(axiom.getDomain()) ? true : !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()) && !this.dualRoles;
        this.suggestedInformation = "";
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.local = this.isPositiveOWLClassExpression((OWLClassExpression)axiom.getRange()) ? true : !this.foreignSignature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()) && !this.dualRoles;
        this.suggestedInformation = "";
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.local = !this.foreignSignature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) && !this.dualRoles;
        this.suggestedInformation = "An OWLDataPropertyRangeAxiom can only be bottom local if the property does not belong to the external signature.";
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.suggestedInformation = "A OWLObjectPropertyChainSubPropertyAxiom axiom is local iff involved properties do not belong to the external signature.";
        if (!this.dualRoles) {
            for (OWLObjectPropertyExpression propExp : axiom.getPropertyChain()) {
                if (!this.foreignSignature.contains(propExp.asOWLObjectProperty())) continue;
                this.local = false;
                return;
            }
            this.local = true;
        } else {
            this.local = this.dualRoles && !this.foreignSignature.contains(axiom.getSuperProperty().asOWLObjectProperty());
        }
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.local = true;
        if (axiom.getSubject() instanceof IRI) {
            if (this.foreignSignature.contains(this.manager.getOWLDataFactory().getOWLClass((IRI)axiom.getSubject())) || this.foreignSignature.contains(this.manager.getOWLDataFactory().getOWLObjectProperty((IRI)axiom.getSubject())) || this.foreignSignature.contains(this.manager.getOWLDataFactory().getOWLDataProperty((IRI)axiom.getSubject()))) {
                this.local = axiom.getAnnotation().getValue() instanceof IRI ? this.ignoreAssertions || !this.considerEntityAnnotations : (axiom.getAnnotation().getValue() instanceof OWLAnonymousIndividual ? this.ignoreAssertions || !this.considerEntityAnnotations : !this.considerEntityAnnotations);
            }
        } else if (axiom.getSubject() instanceof OWLAnonymousIndividual) {
            this.local = this.ignoreAssertions || !this.considerEntityAnnotations;
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.local = !this.dualRoles && !this.foreignSignature.contains(axiom.getSubProperty()) ? true : this.dualRoles && !this.foreignSignature.contains(axiom.getSuperProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.local = !this.foreignSignature.contains(axiom.getProperty()) && !this.dualRoles;
        this.suggestedInformation = "";
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.local = !this.foreignSignature.contains(axiom.getProperty()) && !this.dualRoles;
        this.suggestedInformation = "An OWLAnnotationPropertyRangeAxiom can only be bottom local if the property does not belong to the external signature.";
    }

    public void visit(OWLImportsDeclaration axiom) {
        this.local = false;
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.suggestedInformation = "An OWLDeclarationAxiom is local if the declared entity does not belongs to the foreign signature.";
        this.local = !this.foreignSignature.contains(axiom.getEntity());
    }

    public void visit(SWRLRule axiom) {
        this.local = false;
        this.suggestedInformation = "Currently, a SWRLRule axiom is always considered non-local.";
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.local = false;
        this.suggestedInformation = "Currently, a HasKey axiom is always considered non-local.";
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.local = false;
        this.suggestedInformation = "Currently, a OWLDatatypeDefinition axiom is always considered non-local.";
    }

    private class NegativeOWLClassExpressionVisitor
    implements OWLClassExpressionVisitor {
        boolean isNegativeDescription;

        public boolean isNegativeDescription() {
            return this.isNegativeDescription;
        }

        public void visit(OWLClass desc) {
            this.isNegativeDescription = desc.equals(SyntacticLocalityChecker.this.Nothing()) ? true : !SyntacticLocalityChecker.this.foreignSignature.contains(desc) && !SyntacticLocalityChecker.this.dualConcepts;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression clsDesc : desc.getOperands()) {
                if (!SyntacticLocalityChecker.this.isNegativeOWLClassExpression(clsDesc)) continue;
                this.isNegativeDescription = true;
                return;
            }
            this.isNegativeDescription = false;
        }

        public void visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression clsDesc : desc.getOperands()) {
                if (SyntacticLocalityChecker.this.isNegativeOWLClassExpression(clsDesc)) continue;
                this.isNegativeDescription = false;
                return;
            }
            this.isNegativeDescription = true;
        }

        public void visit(OWLObjectComplementOf desc) {
            this.isNegativeDescription = SyntacticLocalityChecker.this.isPositiveOWLClassExpression(desc.getOperand());
        }

        public void visit(OWLObjectOneOf desc) {
            this.isNegativeDescription = false;
        }

        public void visit(OWLDataOneOf desc) {
            this.isNegativeDescription = false;
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.isNegativeDescription = SyntacticLocalityChecker.this.dualRoles && SyntacticLocalityChecker.this.isNegativeOWLClassExpression((OWLClassExpression)desc.getFiller()) && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.isNegativeDescription = SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.isNegativeDescription = SyntacticLocalityChecker.this.isNegativeOWLClassExpression((OWLClassExpression)desc.getFiller()) ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualConcepts ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectHasSelf desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLObjectHasValue desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) && !SyntacticLocalityChecker.this.foreignSignature.contains(desc.getValue());
        }

        public void visit(OWLDataHasValue desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.isNegativeDescription = desc.isQualified() ? (SyntacticLocalityChecker.this.isNegativeOWLClassExpression((OWLClassExpression)desc.getFiller()) ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty())) : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataMinCardinality desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualConcepts ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.isNegativeDescription = desc.isQualified() ? SyntacticLocalityChecker.this.dualRoles && SyntacticLocalityChecker.this.isNegativeOWLClassExpression((OWLClassExpression)desc.getFiller()) && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) : SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.isNegativeDescription = SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.isNegativeDescription = desc.isQualified() ? SyntacticLocalityChecker.this.isNegativeOWLClassExpression((OWLClassExpression)desc.getFiller()) && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) : !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataExactCardinality desc) {
            this.isNegativeDescription = !SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }
    }

    private class PositiveOWLClassExpressionVisitor
    implements OWLClassExpressionVisitor {
        boolean isPositiveDescription;

        public boolean isPositiveDescription() {
            return this.isPositiveDescription;
        }

        public void visit(OWLClass desc) {
            this.isPositiveDescription = desc.equals(SyntacticLocalityChecker.this.Thing()) ? true : SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(desc);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression clsDesc : desc.getOperands()) {
                if (SyntacticLocalityChecker.this.isPositiveOWLClassExpression(clsDesc)) continue;
                this.isPositiveDescription = false;
                return;
            }
            this.isPositiveDescription = true;
        }

        public void visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression clsDesc : desc.getOperands()) {
                if (!SyntacticLocalityChecker.this.isPositiveOWLClassExpression(clsDesc)) continue;
                this.isPositiveDescription = true;
                return;
            }
            this.isPositiveDescription = false;
        }

        public void visit(OWLObjectComplementOf desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.isNegativeOWLClassExpression(desc.getOperand());
        }

        public void visit(OWLObjectOneOf desc) {
            this.isPositiveDescription = false;
        }

        public void visit(OWLDataOneOf desc) {
            this.isPositiveDescription = false;
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.isPositiveOWLClassExpression((OWLClassExpression)desc.getFiller()) ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualConcepts ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) && SyntacticLocalityChecker.this.isPositiveOWLClassExpression((OWLClassExpression)desc.getFiller());
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectHasSelf desc) {
            this.isPositiveDescription = false;
        }

        public void visit(OWLObjectHasValue desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) && !SyntacticLocalityChecker.this.foreignSignature.contains(desc.getValue());
        }

        public void visit(OWLDataHasValue desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.isPositiveDescription = desc.isQualified() ? SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty()) && SyntacticLocalityChecker.this.isPositiveOWLClassExpression((OWLClassExpression)desc.getFiller()) : SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataMinCardinality desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.isPositiveOWLClassExpression((OWLClassExpression)desc.getFiller()) ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.isPositiveDescription = desc.isQualified() ? (SyntacticLocalityChecker.this.dualConcepts ? true : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty())) : !SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.isPositiveDescription = desc.isQualified() ? SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(desc.getProperty()) && SyntacticLocalityChecker.this.isPositiveOWLClassExpression((OWLClassExpression)desc.getFiller()) : SyntacticLocalityChecker.this.dualRoles && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty());
        }

        public void visit(OWLDataExactCardinality desc) {
            this.isPositiveDescription = SyntacticLocalityChecker.this.dualRoles && SyntacticLocalityChecker.this.dualConcepts && !SyntacticLocalityChecker.this.foreignSignature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
        }
    }
}

