/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality.test;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.syntactic_locality.ModuleExtractorManager;
import uk.ac.manchester.syntactic_locality.utils.ReadFile;

public class CreatePhysicalOntologyModule {
    private OWLOntologyManager externalOntologyManager;
    private OWLOntology ontoToModularize;
    private IRI extOntoIRI;
    private static final String defaultModuleURI = "http://krono.act.uji.es/Links/ontologies/module.owl";
    private OWLOntology module;
    private String typeOfModule;
    private Set<String> signatureNames = new HashSet<String>();
    private HashSet<OWLEntity> matchedSignature = new HashSet();
    private Map<String, OWLEntity> name2entity = new HashMap<String, OWLEntity>();
    private Set<OWLEntity> ontologyEntities;
    private IRI physicalModuleURI;
    private ModuleExtractorManager moduleManager;

    public CreatePhysicalOntologyModule(String ontoURIStr, String fileSignature, String typeOfModule, String outputFile) {
        this(ontoURIStr, fileSignature, typeOfModule, outputFile, defaultModuleURI);
    }

    public CreatePhysicalOntologyModule(String ontoURIStr, String fileSignature, String ModuleType, String outputFile, String moduleURIStr) {
        long init = Calendar.getInstance().getTimeInMillis();
        this.extOntoIRI = IRI.create((String)ontoURIStr.replace("\\", "//"));
        if (!this.loadExternalOntology()) {
            return;
        }
        long fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("**Time for Loading Ontology (s): " + ((double)fin - (double)init) / 1000.0);
        this.typeOfModule = ModuleType;
        init = Calendar.getInstance().getTimeInMillis();
        this.getSignatureFromFile(fileSignature);
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("**Time for getting matched signature (s): " + ((double)fin - (double)init) / 1000.0);
        init = Calendar.getInstance().getTimeInMillis();
        this.moduleManager = new ModuleExtractorManager(this.ontoToModularize, this.typeOfModule, true, false, false);
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("**Time for creating module manager (s): " + ((double)fin - (double)init) / 1000.0);
        this.physicalModuleURI = outputFile.startsWith("/") ? IRI.create((String)("file:" + outputFile.replace("\\", "//"))) : IRI.create((String)("file:/" + outputFile.replace("\\", "//")));
        init = Calendar.getInstance().getTimeInMillis();
        this.module = this.moduleManager.extractModule(this.matchedSignature, moduleURIStr);
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("**Time for extracting module (s): " + ((double)fin - (double)init) / 1000.0);
        init = Calendar.getInstance().getTimeInMillis();
        this.saveModuleToPhysicalURI();
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("**Time for saving module (s): " + ((double)fin - (double)init) / 1000.0);
        init = Calendar.getInstance().getTimeInMillis();
        this.printModuleData();
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("\n**Time for printing results (s): " + ((double)fin - (double)init) / 1000.0);
    }

    private String getEntityLabel(String uriStr) {
        if (uriStr.indexOf("#") >= 0) {
            return uriStr.split("#")[1];
        }
        return uriStr;
    }

    private boolean loadExternalOntology() {
        this.externalOntologyManager = OWLManager.createOWLOntologyManager();
        try {
            this.ontoToModularize = this.externalOntologyManager.loadOntology(this.extOntoIRI);
            this.ontologyEntities = this.ontoToModularize.getSignature();
            for (OWLEntity ent : this.ontologyEntities) {
                this.name2entity.put(this.getEntityLabel(ent.getIRI().toString()), ent);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading ontology form URI: " + this.extOntoIRI.toString());
            e.printStackTrace();
            this.ontoToModularize = null;
            return false;
        }
    }

    private void getSignatureFromFile(String fileSignature) {
        try {
            ReadFile reader = new ReadFile(fileSignature);
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    this.signatureNames.add(line);
                }
                line = reader.readLine();
            }
            reader.closeBuffer();
            this.getMatchedSignature();
        }
        catch (Exception e) {
            System.out.println("Error reading file: " + fileSignature + "\n" + e.getLocalizedMessage());
        }
    }

    private void getMatchedSignature() {
        Set<String> keys = this.name2entity.keySet();
        for (String entSig : this.signatureNames) {
            if (keys.contains(entSig)) {
                this.matchedSignature.add(this.name2entity.get(entSig));
                continue;
            }
            System.err.println("\tThe entity '" + entSig.toString() + "' has not a correspondence in the external ontology.");
        }
    }

    private void saveModuleToPhysicalURI() {
        try {
            this.externalOntologyManager.saveOntology(this.module, (OWLOntologyFormat)new RDFXMLOntologyFormat(), this.physicalModuleURI);
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void printModuleData() {
        System.out.println("\nExtracted " + this.typeOfModule + " Module for a signature size of " + this.matchedSignature.size());
        if (this.signatureNames.size() > this.matchedSignature.size()) {
            System.err.println("Not all the entities of the signature were matched/aligned with an ontology entity.");
        }
        System.out.println("Number of Axioms -> Module: " + this.moduleManager.getNumberOfAxiomsExtractedModule() + " / Whole Ontology: " + this.moduleManager.getNumberOfAxiomsOntoToModularize());
        System.out.println("Number of Classes -> Module: " + this.moduleManager.getNumberOfClassesExtractedModule() + " / Whole Ontology: " + this.moduleManager.getNumberOfClassesOntoToModularize());
        System.out.println("Number of Roles -> Module: " + this.moduleManager.getNumberOfRolesExtractedModule() + " / Whole Ontology: " + this.moduleManager.getNumberOfRolesOntoToModularize());
        System.out.println("Number of Individuals -> Module: " + this.moduleManager.getNumberOfIndividualsExtractedModule() + " / Whole Ontology: " + this.moduleManager.getNumberOfIndividualsOntoToModularize());
        double percentSize = ((double)this.moduleManager.getNumberOfAxiomsExtractedModule() * 100.0 / (double)(this.moduleManager.getNumberOfAxiomsOntoToModularize() + 1) + (double)this.moduleManager.getNumberOfClassesExtractedModule() * 100.0 / ((double)this.moduleManager.getNumberOfClassesOntoToModularize() + 0.1) + (double)this.moduleManager.getNumberOfRolesExtractedModule() * 100.0 / ((double)this.moduleManager.getNumberOfRolesOntoToModularize() + 0.1)) / 3.0;
        int decimales = 2;
        double roundedPercentSize = (double)Math.round(percentSize * Math.pow(10.0, decimales)) / Math.pow(10.0, decimales);
        System.out.println("Relative size: " + roundedPercentSize + " % of the ontology");
    }

    public static void usage() {
        System.out.println("Usage: The method requires 4 or 5 arguments.\n  java -jar locality_module_extractor.jar Onto_URI_Name Signature_File ModuleType OutputFile [ModuleUri]\n\t Ontology URI i.e.:\n\t\t http://krono.act.uji.es/Links/ontologies/gale_protege.owl\n\t\t file:/tmp/MyOnt.owl\n\t\t ftp://ftp.fao.org/gi/gil/gilws/aims/kos/agrovoc_formats/owl/agrovoc_20050401.owl\n\t File with signature (one entity per line):\n\t\t Juvenile Idiopathic Arthritis\n\t\t Heart\n\t\t hasAttribute\n\t\t # Commented line.\n\t Type of module: 'UPPER_MODULE' or 'UM', 'LOWER_MODULE' or 'LM', 'LOWER_UPPER_MODULE' or 'LUM', 'DUAL_CONCEPTS_MODULE' or 'DCM', 'DUAL_ROLES_MODULE' or 'DRM\n\t\t See report documentation in http://krono.act.uji.es/people/Ernesto/safety-ontology-reuse for more information.\n\t Output Filepath: absolute path of the owl output module.\n\t Module URI (optional). Default: http://krono.act.uji.es/Links/ontologies/module_Signature_File.owl");
    }

    public static void main(String[] args) {
        long init = Calendar.getInstance().getTimeInMillis();
        if (args.length == 1 && args[0].equals("--help") || args.length != 4 && args.length != 5) {
            CreatePhysicalOntologyModule.usage();
            return;
        }
        if (args.length == 4) {
            new CreatePhysicalOntologyModule(args[0], args[1], args[2], args[3]);
        } else {
            new CreatePhysicalOntologyModule(args[0], args[1], args[2], args[3], args[4]);
        }
        long fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("\nTOTAL TIME (s): " + ((double)fin - (double)init) / 1000.0);
    }
}

