/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality.test;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.DLExpressivityChecker;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;

public class ExtractModules4AllOntologyEntities {
    private OWLOntologyManager externalOntologyManager;
    private OWLOntology ontoToModularize;
    private IRI extOntoIRI = IRI.create((String)"file:/home/ernesto/Desktop/FMADL_2_0_with_synonyms.owl");
    private static final String defaultModuleIRI = "http://krono.act.uji.es/Links/ontologies/module_";
    private OWLOntology module;
    private IRI physicalModuleIRI;
    private IRI moduleIRI;
    private ModuleExtractor extractor;

    public ExtractModules4AllOntologyEntities() {
        this.loadExternalOntology();
        this.initExtractor();
        HashSet<OWLOntology> set4Module = new HashSet<OWLOntology>();
        int num_modules = 0;
        for (OWLEntity ent : this.ontoToModularize.getClassesInSignature()) {
            System.out.println("Extracting module for: " + this.getEntityLabel(ent.getIRI().toString()));
            Set<OWLAxiom> Axioms = this.extractor.extractModuleAxiomsForEntity(ent);
            this.moduleIRI = IRI.create((String)(defaultModuleIRI + this.getEntityLabel(ent.getIRI().toString()) + ".owl"));
            this.module = this.extractor.getModuleFromAxioms(Axioms, this.moduleIRI);
            set4Module.clear();
            set4Module.add(this.module);
            DLExpressivityChecker checker = new DLExpressivityChecker(set4Module);
            System.out.println("\tExpressivity Ontology: " + checker.getDescriptionLogicName());
            this.physicalModuleIRI = IRI.create((String)("file:/home/ernesto/LocalityExtractor/modules/" + this.getEntityLabel(ent.getIRI().toString()) + ".owl"));
            this.saveModuleToPhysicalIRI();
            if (++num_modules <= 15) continue;
            return;
        }
    }

    private boolean loadExternalOntology() {
        this.externalOntologyManager = OWLManager.createOWLOntologyManager();
        try {
            this.ontoToModularize = this.externalOntologyManager.loadOntology(this.extOntoIRI);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading ontology form URI: " + this.extOntoIRI.toString());
            e.printStackTrace();
            this.ontoToModularize = null;
            return false;
        }
    }

    private void saveModuleToPhysicalIRI() {
        try {
            this.externalOntologyManager.saveOntology(this.module, (OWLOntologyFormat)new RDFXMLOntologyFormat(), this.physicalModuleIRI);
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void initExtractor() {
        boolean dualConcepts = false;
        boolean dualRoles = false;
        boolean withannotation = true;
        boolean ignoreassertions = true;
        this.extractor = new ModuleExtractor(this.ontoToModularize, dualConcepts, dualRoles, false, withannotation, ignoreassertions);
    }

    private String getEntityLabel(String iriStr) {
        if (iriStr.indexOf("#") >= 0) {
            return iriStr.split("#")[1];
        }
        return iriStr;
    }

    public static void main(String[] args) {
        new ExtractModules4AllOntologyEntities();
    }
}

