/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality.test;

import java.util.Calendar;
import java.util.HashSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;
import uk.ac.manchester.syntactic_locality.ModuleExtractorManager;

public class TestClass {
    private OWLOntologyManager onto2modularizeManager;
    private OWLDataFactory datafactory;
    private OWLOntology onto2modularize;
    private IRI onto2modularizeIRI;
    private static final String defaultModuleIRI = "http://krono.act.uji.es/Links/ontologies/module.owl";
    private ModuleExtractor extractor;
    private ModuleExtractorManager extractorManager;
    boolean withannotation = false;
    boolean ignoreassertions = true;
    public static long init;
    public static long fin;

    public TestClass(String onto) {
        this.onto2modularizeIRI = IRI.create((String)onto);
        init = Calendar.getInstance().getTimeInMillis();
        this.loadOntology2Modularize();
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("Time loading ontology (s): " + ((double)fin - (double)init) / 1000.0);
    }

    private boolean loadOntology2Modularize() {
        this.onto2modularizeManager = OWLManager.createOWLOntologyManager();
        this.datafactory = this.onto2modularizeManager.getOWLDataFactory();
        try {
            this.onto2modularize = this.onto2modularizeManager.loadOntology(this.onto2modularizeIRI);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error loading ontology form URI: " + this.onto2modularizeIRI.toString());
            e.printStackTrace();
            this.onto2modularize = null;
            return false;
        }
    }

    private String getOntologyIRI() {
        return this.onto2modularize.getOntologyID().getOntologyIRI().toString();
    }

    private OWLEntity getOWLEntityFromIRI(IRI iri) {
        return this.datafactory.getOWLClass(iri);
    }

    private void saveModuleToPhysicalIRI(OWLOntology module, String physicalModuleIRI) {
        try {
            this.onto2modularizeManager.saveOntology(module, (OWLOntologyFormat)new RDFXMLOntologyFormat(), IRI.create((String)physicalModuleIRI));
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void initLowerModulextractor() {
        boolean dualConcepts = true;
        boolean dualRoles = true;
        this.extractor = new ModuleExtractor(this.onto2modularize, dualConcepts, dualRoles, false, this.withannotation, this.ignoreassertions);
    }

    private void initUpperModulextractor() {
        boolean dualConcepts = false;
        boolean dualRoles = false;
        this.extractor = new ModuleExtractor(this.onto2modularize, dualConcepts, dualRoles, false, this.withannotation, this.ignoreassertions);
    }

    private void initLUMModulextractor() {
        String typeOfModule = "LUM";
        this.extractorManager = new ModuleExtractorManager(this.onto2modularize, typeOfModule, false, this.withannotation, this.ignoreassertions);
    }

    private OWLOntology extactModule4Entity(String type, OWLEntity entity) {
        if (type.equals("UM")) {
            this.initUpperModulextractor();
            return this.extractor.getModuleFromAxioms(this.extractor.extractModuleAxiomsForEntity(entity), IRI.create((String)defaultModuleIRI));
        }
        if (type.equals("LM")) {
            this.initLowerModulextractor();
            return this.extractor.getModuleFromAxioms(this.extractor.extractModuleAxiomsForEntity(entity), IRI.create((String)defaultModuleIRI));
        }
        this.initLUMModulextractor();
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>();
        signature.add(entity);
        return this.extractorManager.extractModule(signature, defaultModuleIRI);
    }

    private OWLOntology extactModule4entityset(String type, HashSet<OWLEntity> signature) {
        if (type.equals("UM")) {
            this.initUpperModulextractor();
            return this.extractor.getLocalityModuleForSignatureGroup(signature, defaultModuleIRI);
        }
        if (type.equals("LM")) {
            this.initLowerModulextractor();
            return this.extractor.getLocalityModuleForSignatureGroup(signature, defaultModuleIRI);
        }
        this.initLUMModulextractor();
        return this.extractorManager.extractModule(signature, defaultModuleIRI);
    }

    public static void main(String[] args) {
        String ontouri = "file:/home/ernesto/FMA_3.0_noMTC_100702.owl";
        String moduletype = "UM";
        moduletype = "LM";
        moduletype = "LUM";
        TestClass test = new TestClass(ontouri);
        String class4module = "Organ";
        OWLEntity entity = test.getOWLEntityFromIRI(IRI.create((String)(String.valueOf(test.getOntologyIRI()) + "#" + class4module)));
        init = Calendar.getInstance().getTimeInMillis();
        OWLOntology module = test.extactModule4Entity(moduletype, entity);
        fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("Time Extracting Module (s): " + ((double)fin - (double)init) / 1000.0);
        test.saveModuleToPhysicalIRI(module, String.valueOf(ontouri) + class4module + moduletype + ".owl");
    }
}

