#!/bin/bash

################################################################################
#Run this script to import the data into the databases
################################################################################

#Time for sleeping to make sure that the server is completely started or stopped
sleeptime=6

#Tables generated by this scripts
tables_size=8
certain_tables=(region0 nation0 supplier0 part0 partsupp0 customer0 orders0 lineitem0 )
prob_tables=(region nation supplier part partsupp customer orders lineitem )

#The systems used in this script
systems_size=3
systems=( Postgres SPROUT MayBMS  )

#The scale factors used in the experiments
scales_size=5
scales=( 0.005 0.01 0.1 0.5 1 )

echo "-----stop existing postgres process and remove existing database clusters"	

for ((k=0;k<$systems_size;k++)) do

	database=../${systems[k]}/database
	bin=$database/bin
	
	$bin/pg_ctl stop -D $database/data

	sleep $sleeptime
	
	rm -f -r $database/data

done

for ((k=0;k<$systems_size;k++)) do

	echo ""
	echo "---------------import data in ${systems[k]}"	
	echo ""	
	
	database=../${systems[k]}/database
	bin=$database/bin
	
	$bin/initdb -D $database/data

	$bin/postgres -p "5432" -D $database/data >"logfile" 2>&1 &

	sleep $sleeptime

	for ((i=0;i<$scales_size;i++)) do

			echo "-----scale factoer = ${scales[i]}"	

			dbname=sf${scales[i]}

			$bin/createdb $dbname
			$bin/psql -d $dbname -f create-table.sql

			for ((j=0; j<$tables_size; j++)) do
				echo "-----create certain table ${prob_tables[j]}"		
				$bin/psql -d $dbname -c "COPY ${certain_tables[j]} FROM '`pwd`/${scales[i]}/${prob_tables[j]}.text' WITH DELIMITER AS '|'"
			done

			if test ${systems[k]} = Postgres
				then
					$bin/psql -d $dbname -c "CREATE SEQUENCE varid"
				
					for ((j=0; j<$tables_size; j++)) do
						echo "-----create probabilistic-like table ${prob_tables[j]}"		
						$bin/psql -d $dbname -c "create table ${prob_tables[j]} as select *, cast ( nextval('varid') as int ) as var, 1 as domain from ${certain_tables[j]}"
					done
				else
					for ((j=0; j<$tables_size; j++)) do
						echo "-----create probabilistic table ${prob_tables[j]}"		
						$bin/psql -d $dbname -c "create table ${prob_tables[j]} as pick tuples from ${certain_tables[j]} with probability prob"
					done
		  	fi

			$bin/psql -d $dbname -f prob_table_keys.sql
		  	
	done
	
	$bin/pg_ctl stop -D $database/data
	
	sleep $sleeptime

done
