#!/bin/bash

################################################################################
#Run this script to generate probabilistic TPC-H data
################################################################################

#Time for sleeping to make sure that the server is completely started or stopped
sleeptime=3

#The scale factors used in the experiments
scales_size=5
scales=( 0.005 0.01 0.1 0.5 1 )

for ((i=0;i<$scales_size;i++)) do

		echo "remove old data file"	

		rm -f *.tbl
		rm -f *.text

		echo "generate data for scale factor ${scales[i]}"	

		./dbgen -s ${scales[i]}
		
		sleep $sleeptime
		
		echo "add probabilities for data of scale factor ${scales[i]}"	
		
		./add_probability
		
		sleep $sleeptime
		
		echo "move data for scale factor ${scales[i]}"	
		
		rm -f ../${scales[i]}/*.text
		
		mv *.text ../${scales[i]}/
		
		sleep $sleeptime
done
