#!/bin/bash

################################################################################
#Run this script to genetate average running time for "aconf"
################################################################################

#Time for sleeping to make sure that the server is completely started or stopped
sleeptime=6 

#The number of runs in the experiments for each query. 
#The first run gets a warm cache and is not calculated in the average time 
run=6

#This is the allocated time for each query. Queries that run out of this time
#is forced to stop. 2000 means 20 minutes.
allocated_time=2000

#The systems used in this script
systems_size=1
systems=( MayBMS )

#The techniques used in this script
techniques_size=1
techniques=( aconf )

#The scale factors used in the experiments
scales_size=5
scales=( 0.005 0.01 0.1 0.5 1 )

#The queries used in the experiments
query_size=6
query=( 1 2 3 4 5 6 ) 

for ((m=0;m<$systems_size;m++)) do

	echo "----------------------------------"  
	echo "test for ${techniques[m]} in ${systems[m]} system"
	echo "----------------------------------" 		

	database=../${systems[m]}/database
	bin=$database/bin
	data=$database/data
	
	average=average_time_${techniques[m]}
	rm -f $average

	for ((i=0;i<$scales_size;i++)) do

		echo "----------------------------------"  
		echo "test for ${techniques[m]} of scale factor ${scales[i]} in ${systems[m]}"
		echo "----------------------------------" 

		$bin/postgres -p "5432" -D $data >"logfile" 2>&1 &
		sleep $sleeptime

		dbname=sf${scales[i]}
	  	
			for ((j=0; j<$query_size; j++)) do

				echo "query ${query[j]}"
			
				out_file=all_running_time/${techniques[m]}_${query[j]}_time_sf_${scales[i]}
				rm -f $out_file
		
				for ((k=0; k<$run; k++)) do
			
					echo " run $k "
					echo " run $k " >> $out_file
				

                 /usr/bin/time -f "%e" -o $out_file -a $bin/psql -d $dbname -f ../queries/${techniques[m]}/${techniques[m]}_${query[j]}.sql > /dev/null $file &		  	
			  	
			  	while [ $(ps -p $! -o etime= | tr -d ": ") -lt $allocated_time ]
				do
 					sleep 60
				done 2> /dev/null

				process_info=`ps -p "$!" | awk '/:/' | awk '{ print $1 }'`
				
				if [ -z $process_info ]
					then
						echo "--------------------------------------"
						echo "This query finished in allocated time."
						echo "--------------------------------------"
						
						timeout=0
					else
						kill -9 $!
						
						sleep $sleeptime

						pid=`ps -A -f | awk '/\[local\]\ SELECT/' | awk '{ print $2 }' `

						kill -9 $pid
						
						timeout=1
						
						echo "-----------------------------------------------------------------------------------"
						echo "The query ran out of allocated time and the process running it was killed."
						echo "It is expected to lose the connection to the server at this point. It is not a bug."
						echo "-----------------------------------------------------------------------------------"						
					
				fi
				
				sleep $sleeptime
			  	
				done

				counter=0	
		
				for k in `sed -n -e '/^[0-9]/p' $out_file`; do
		
					time[$counter]=$k
		
					counter=$(($counter + 1))
			
			  	done

			  	echo "average time for query ${query[j]} of scale factor ${scales[i]}" >> $average
			  	
			  	if [ $timeout -eq 0 ]
			  		then
			  			./average ${time[1]} ${time[2]} ${time[3]} ${time[4]} ${time[5]} >> $average
					else
						echo "NULL" >> $average
				fi
				
			done	

		$bin/pg_ctl stop -D $data
		sleep $sleeptime

	done

done




