set title "Query 1"
#set title ".."

# Deletes all arrows
#set noarrow 

# Deletes all Label
#set nolabel

# Do not create a log file
set nolog

set xlabel "TPC-H scale factor (ln scale)" 0,0
set ylabel "time in sec (ln scale)" 0,0
set key 0.04,250
#set key left top
#set format x "%.0f"
#set pointsize 1.0

set logscale x
set logscale y
set xrange [0.0045:1.1]
set yrange [0.06:1000]
set xtics (0.005,0.01,0.1,0.5,1)

# save the plot as postscript
set out 'query1.eps'
set size 0.55, 0.45
set terminal postscript eps enhanced "Helvetica" 14
#set ytics 1

plot "query1.data"u ($1):($5) title "aconf" w linespoints pointtype 2, \
     "query1.data" u ($1):($5) title "" w points pt 2,\
     "query1.data"u ($1):($4) title "conf" w linespoints pointtype 4,\
     "query1.data" u ($1):($4) title "" w points pt 4, \
     "query1.data" u ($1):($3) title "ours" w linespoints pointtype 6, \
     "query1.data" u ($1):($3) title "" w points pt 6, \
     "query1.data" u ($1):($2) title "plain" w linespoints pointtype 5, \
     "query1.data" u ($1):($2) title "" w points pt 5;

#replot
#set size 1,1
#set terminal windows


