#!/bin/bash

#Queries used in this experiment
query_size=6
query=( 1 2 3 4 5 6 ) 

#Time for sleeping to make sure that the server is completely started or stopped
sleeptime=6

#These are directories where the the system is installed
database=../Postgres/database
bin=$database/bin
data=$database/data

#The output file for this figure
output=figures/figure14	

$bin/postgres -p "5432" -D $data >"logfile" 2>&1 &
sleep $sleeptime

echo "----------------------------------"  
echo "generate lineage size"
echo "----------------------------------" 		

rm -f count

for ((i=0; i<$query_size; i++)) do

	echo "query ${query[i]}"

	$bin/psql -d sf1 -f ../queries/figure14/figure14_${query[i]}.sql >> count	

done

$bin/pg_ctl stop -D $data
sleep $sleeptime

echo "Query & Lineage size & \# duplicates  per distinct tuple\\\ \hline\hline"  > $output

counter=1

for k in `sed -n -e '/^[ ][0-9]/p' count`; do
		
	time[$counter]=$k

    case "$counter" in

    [1-5])
            echo "$counter & $k & $k (Boolean Query) \\\ \hline"	>> $output
            ;;
    6)
            echo -n "$counter & $k & "		>> $output
            ;;
    7)
            echo "min #duplicates: $k \\\ \hline " >> $output
            ;;
    8)
			echo "  &    	& max #duplicates: $k \\\ \hline" >> $output
            ;;
    9)
			echo "  &    	& avg #duplicates: $k \\\ \hline" >> $output
            ;;
    esac
		
	counter=$(($counter + 1))
			
done




