#!/bin/bash

#Files used for collecting average running time
files_size=5
files=( plain ours conf aconf sort )

#The scale factors used in the experiments
scales_size=5
scales=( 0.005 0.01 0.1 0.5 1  )

#Queries used in this experiment
queries_size=6
queries=( 1 2 3 4 5 6 )

#This is the distance in the array between two running time belonging to the 
#same query and scale factor
distance=$(($scales_size * $queries_size))

counter=0

for ((i=0;i<$queries_size;i++)) do

	echo -e "#scale \t\t plain \t\t ours \t\t conf \t\t aconf \t\t sort" > figures/query${queries[i]}.data

done

counter=0

for ((i=0;i<$files_size;i++)) do

	for k in `sed -n -e '/^[0-9, N]/p' average_time_${files[i]}`; do
		
		time[$counter]=$k
		
		counter=$(($counter + 1))
			
	done

done

counter=0

for ((i=0;i<$scales_size;i++)) do

	for ((j=0;j<$queries_size;j++)) do
	
		pos_plain=$counter
		pos_ours=$(($counter + $distance))
		pos_conf=$(($counter + $distance + $distance))
		pos_aconf=$(($counter + $distance + $distance + $distance))
		pos_sort=$(($counter + $distance + $distance + $distance + $distance))
	
		echo -e "${scales[i]} \t ${time[pos_plain]} \t ${time[pos_ours]} \t ${time[pos_conf]} \t ${time[pos_aconf]} \t ${time[pos_sort]}" >> figures/query${queries[j]}.data	
	
		counter=$(($counter + 1))
		
	done

done

cd figures

gnuplot *.plt


