/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.util.NumberedString;

class AbstractSootMethodRef
implements SootMethodRef {
    private final SootClass declaringClass;
    private final String name;
    private final List parameterTypes;
    private final Type returnType;
    private final boolean isStatic;
    private NumberedString subsig;

    public AbstractSootMethodRef(SootClass declaringClass, String name, List parameterTypes, Type returnType, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.name = name;
        ArrayList l = new ArrayList();
        l.addAll(parameterTypes);
        this.parameterTypes = Collections.unmodifiableList(l);
        this.returnType = returnType;
        this.isStatic = isStatic;
        if (declaringClass == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null class");
        }
        if (name == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null name");
        }
        if (parameterTypes == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null parameterTypes");
        }
        if (returnType == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null returnType");
        }
    }

    public SootClass declaringClass() {
        return this.declaringClass;
    }

    public String name() {
        return this.name;
    }

    public List parameterTypes() {
        return this.parameterTypes;
    }

    public Type returnType() {
        return this.returnType;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public NumberedString getSubSignature() {
        if (this.subsig == null) {
            this.subsig = Scene.v().getSubSigNumberer().findOrAdd(SootMethod.getSubSignature(this.name, this.parameterTypes, this.returnType));
        }
        return this.subsig;
    }

    public String getSignature() {
        return SootMethod.getSignature(this.declaringClass, this.name, this.parameterTypes, this.returnType);
    }

    public Type parameterType(int i) {
        return (Type)this.parameterTypes.get(i);
    }

    public SootMethod resolve() {
        return this.resolve(null);
    }

    private SootMethod checkStatic(SootMethod ret) {
        if (ret.isStatic() != this.isStatic()) {
            throw new ResolutionFailedException("Resolved " + this + " to " + ret + " which has wrong static-ness");
        }
        return ret;
    }

    private SootMethod resolve(StringBuffer trace) {
        SootClass cl = this.declaringClass;
        while (true) {
            if (trace != null) {
                trace.append("Looking in " + cl + " which has methods " + cl.getMethods() + "\n");
            }
            if (cl.declaresMethod(this.getSubSignature())) {
                return this.checkStatic(cl.getMethod(this.getSubSignature()));
            }
            if (Scene.v().allowsPhantomRefs() && cl.isPhantom()) {
                SootMethod m = new SootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
                m.setPhantom(true);
                cl.addMethod(m);
                return this.checkStatic(m);
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        cl = this.declaringClass;
        while (true) {
            LinkedList<SootClass> queue = new LinkedList<SootClass>();
            queue.addAll(cl.getInterfaces());
            while (!queue.isEmpty()) {
                SootClass iface = (SootClass)queue.removeFirst();
                if (trace != null) {
                    trace.append("Looking in " + iface + " which has methods " + iface.getMethods() + "\n");
                }
                if (iface.declaresMethod(this.getSubSignature())) {
                    return this.checkStatic(iface.getMethod(this.getSubSignature()));
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        if (trace == null) {
            throw new ClassResolutionFailedException();
        }
        return null;
    }

    public String toString() {
        return this.getSignature();
    }

    public class ClassResolutionFailedException
    extends ResolutionFailedException {
        public ClassResolutionFailedException() {
            super("Class " + AbstractSootMethodRef.this.declaringClass + " doesn't have method " + AbstractSootMethodRef.this.name + "(" + AbstractSootMethodRef.this.parameterTypes + ")" + " : " + AbstractSootMethodRef.this.returnType + "; failed to resolve in superclasses and interfaces");
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(super.toString());
            AbstractSootMethodRef.this.resolve(ret);
            return ret.toString();
        }
    }
}

