/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import soot.ClassSource;
import soot.G;
import soot.JastAddInitialResolver;
import soot.SootClass;
import soot.SourceLocator;
import soot.javaToJimple.IInitialResolver;
import soot.javaToJimple.InitialResolver;
import soot.options.Options;
import soot.toolkits.astmetrics.ComputeASTMetrics;

public class JavaClassSource
extends ClassSource {
    private File fullPath;

    public JavaClassSource(String className, File fullPath) {
        super(className);
        this.fullPath = fullPath;
    }

    public JavaClassSource(String className) {
        super(className);
    }

    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .java]: " + this.className);
        }
        IInitialResolver resolver = Options.v().polyglot() ? InitialResolver.v() : JastAddInitialResolver.v();
        if (this.fullPath != null) {
            resolver.formAst(this.fullPath.getPath(), SourceLocator.v().sourcePath(), this.className);
        }
        IInitialResolver.Dependencies references = resolver.resolveFromJavaFile(sc);
        if (Options.v().ast_metrics()) {
            ComputeASTMetrics metrics = new ComputeASTMetrics(InitialResolver.v().getAst());
            metrics.apply();
        }
        return references;
    }
}

