/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Hierarchy;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.TrapManager;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.InstanceInvokeEdgesPred;
import soot.jimple.toolkits.callgraph.Targets;
import soot.jimple.toolkits.invoke.AccessManager;
import soot.jimple.toolkits.invoke.SynchronizerManager;
import soot.jimple.toolkits.invoke.ThrowManager;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.options.SMBOptions;

public class StaticMethodBinder
extends SceneTransformer {
    public StaticMethodBinder(Singletons.Global g) {
    }

    public static StaticMethodBinder v() {
        return G.v().soot_jimple_toolkits_invoke_StaticMethodBinder();
    }

    protected void internalTransform(String phaseName, Map opts) {
        Filter instanceInvokesFilter = new Filter(new InstanceInvokeEdgesPred());
        SMBOptions options = new SMBOptions(opts);
        String modifierOptions = PhaseOptions.getString(opts, "allowed-modifier-changes");
        HashMap<SootMethod, SootMethod> instanceToStaticMap = new HashMap<SootMethod, SootMethod>();
        CallGraph cg = Scene.v().getCallGraph();
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        for (SootClass c : Scene.v().getApplicationClasses()) {
            LinkedList<SootMethod> methodsList = new LinkedList<SootMethod>();
            Iterator<SootMethod> it = c.methodIterator();
            while (it.hasNext()) {
                methodsList.add(it.next());
            }
            while (!methodsList.isEmpty()) {
                SootMethod container2 = (SootMethod)methodsList.removeFirst();
                if (!container2.isConcrete() || !instanceInvokesFilter.wrap(cg.edgesOutOf(container2)).hasNext()) continue;
                JimpleBody b = (JimpleBody)container2.getActiveBody();
                ArrayList<Unit> unitList = new ArrayList<Unit>();
                unitList.addAll(b.getUnits());
                for (Stmt stmt : unitList) {
                    Targets targets;
                    InvokeExpr ie;
                    if (!stmt.containsInvokeExpr() || (ie = stmt.getInvokeExpr()) instanceof StaticInvokeExpr || ie instanceof SpecialInvokeExpr || !(targets = new Targets(instanceInvokesFilter.wrap(cg.edgesOutOf(stmt)))).hasNext()) continue;
                    SootMethod target = (SootMethod)targets.next();
                    if (targets.hasNext() || !AccessManager.ensureAccess(container2, target, modifierOptions) || !target.getDeclaringClass().isApplicationClass() || !target.isConcrete() || target.getDeclaringClass() == Scene.v().getSootClass("java.lang.Object")) continue;
                    boolean targetUsesThis = true;
                    if (!instanceToStaticMap.containsKey(target)) {
                        ArrayList<RefType> newParameterTypes = new ArrayList<RefType>();
                        if (targetUsesThis) {
                            newParameterTypes.add(RefType.v(target.getDeclaringClass().getName()));
                        }
                        newParameterTypes.addAll(target.getParameterTypes());
                        String newName = target.getName() + "_static";
                        while (target.getDeclaringClass().declaresMethod(newName, newParameterTypes, target.getReturnType())) {
                            newName = newName + "_static";
                        }
                        SootMethod ct = new SootMethod(newName, newParameterTypes, target.getReturnType(), target.getModifiers() | 8, target.getExceptions());
                        target.getDeclaringClass().addMethod(ct);
                        methodsList.addLast(ct);
                        ct.setActiveBody((Body)target.getActiveBody().clone());
                        Iterator<Unit> oldUnits = target.getActiveBody().getUnits().iterator();
                        Iterator<Unit> newUnits = ct.getActiveBody().getUnits().iterator();
                        while (newUnits.hasNext()) {
                            Stmt oldStmt = (Stmt)oldUnits.next();
                            Stmt newStmt = (Stmt)newUnits.next();
                            Iterator<Edge> edges = cg.edgesOutOf(oldStmt);
                            while (edges.hasNext()) {
                                Edge e = edges.next();
                                cg.addEdge(new Edge(ct, newStmt, e.tgt(), e.kind()));
                                cg.removeEdge(e);
                            }
                        }
                        Body newBody = ct.getActiveBody();
                        PatchingChain<Unit> units = newBody.getUnits();
                        Iterator<Unit> unitsIt = newBody.getUnits().snapshotIterator();
                        while (unitsIt.hasNext()) {
                            Stmt st = (Stmt)unitsIt.next();
                            if (!(st instanceof IdentityStmt)) continue;
                            IdentityStmt is = (IdentityStmt)st;
                            if (is.getRightOp() instanceof ThisRef) {
                                if (targetUsesThis) {
                                    units.swapWith(st, Jimple.v().newIdentityStmt(is.getLeftOp(), Jimple.v().newParameterRef(is.getRightOp().getType(), 0)));
                                    continue;
                                }
                                units.remove(st);
                                break;
                            }
                            if (!targetUsesThis || !(is.getRightOp() instanceof ParameterRef)) continue;
                            ParameterRef ro = (ParameterRef)is.getRightOp();
                            ro.setIndex(ro.getIndex() + 1);
                        }
                        instanceToStaticMap.put(target, ct);
                    }
                    SootMethod clonedTarget = (SootMethod)instanceToStaticMap.get(target);
                    Value thisToAdd = ((InstanceInvokeExpr)ie).getBase();
                    if (options.insert_redundant_casts() && targetUsesThis) {
                        SootClass localType = ((RefType)((InstanceInvokeExpr)ie).getBase().getType()).getSootClass();
                        SootClass parameterType = target.getDeclaringClass();
                        if (localType.isInterface() || hierarchy.isClassSuperclassOf(localType, parameterType)) {
                            Local castee = Jimple.v().newLocal("__castee", parameterType.getType());
                            b.getLocals().add(castee);
                            b.getUnits().insertBefore(Jimple.v().newAssignStmt(castee, Jimple.v().newCastExpr(((InstanceInvokeExpr)ie).getBase(), parameterType.getType())), (Unit)stmt);
                            thisToAdd = castee;
                        }
                    }
                    ArrayList<Value> newArgs = new ArrayList<Value>();
                    if (targetUsesThis) {
                        newArgs.add(thisToAdd);
                    }
                    newArgs.addAll(ie.getArgs());
                    StaticInvokeExpr sie = Jimple.v().newStaticInvokeExpr(clonedTarget.makeRef(), newArgs);
                    ValueBox ieBox = stmt.getInvokeExprBox();
                    ieBox.setValue(sie);
                    cg.addEdge(new Edge(container2, stmt, clonedTarget));
                    if (options.insert_null_checks()) {
                        boolean caught = TrapManager.isExceptionCaughtAt(Scene.v().getSootClass("java.lang.NullPointerException"), stmt, b);
                        if (caught) {
                            IfStmt insertee = Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), stmt);
                            b.getUnits().insertBefore(insertee, (Unit)stmt);
                            insertee.setTarget(stmt);
                            ThrowManager.addThrowAfter(b, insertee);
                        } else {
                            Stmt throwPoint = ThrowManager.getNullPointerExceptionThrower(b);
                            b.getUnits().insertBefore(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), throwPoint), (Unit)stmt);
                        }
                    }
                    if (target.isSynchronized()) {
                        clonedTarget.setModifiers(clonedTarget.getModifiers() & 0xFFFFFFDF);
                        SynchronizerManager.v().synchronizeStmtOn(stmt, b, (Local)((InstanceInvokeExpr)ie).getBase());
                    }
                    LocalNameStandardizer.v().transform(b, phaseName + ".lns");
                }
            }
        }
    }
}

