/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import soot.Body;
import soot.PointsToAnalysis;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.shimple.ShimpleFactory;
import soot.shimple.toolkits.graph.GlobalValueNumberer;
import soot.shimple.toolkits.graph.SimpleGlobalValueNumberer;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.BlockGraphConverter;
import soot.toolkits.graph.CytronDominanceFrontier;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.ExceptionalBlockGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.HashReversibleGraph;
import soot.toolkits.graph.ReversibleGraph;
import soot.toolkits.graph.SimpleDominatorsFinder;
import soot.toolkits.graph.UnitGraph;

public class DefaultShimpleFactory
implements ShimpleFactory {
    protected Body body;
    protected BlockGraph bg;
    protected UnitGraph ug;
    protected DominatorsFinder dFinder;
    protected DominatorTree dTree;
    protected DominanceFrontier dFrontier;
    protected PointsToAnalysis pta;
    protected CallGraph cg;
    protected SideEffectAnalysis sea;
    protected GlobalValueNumberer gvn;
    protected ReversibleGraph rbg;
    protected DominatorTree rdTree;
    protected DominanceFrontier rdFrontier;
    protected DominatorsFinder rdFinder;

    public void clearCache() {
        this.bg = null;
        this.ug = null;
        this.dFinder = null;
        this.dTree = null;
        this.dFrontier = null;
        this.pta = null;
        this.cg = null;
        this.sea = null;
        this.gvn = null;
        this.rbg = null;
        this.rdTree = null;
        this.rdFinder = null;
        this.rdFrontier = null;
    }

    public void setBody(Body body) {
        this.body = body;
        this.clearCache();
    }

    public Body getBody() {
        if (this.body == null) {
            throw new RuntimeException("Assertion failed: Call setBody() first.");
        }
        return this.body;
    }

    public ReversibleGraph getReverseBlockGraph() {
        if (this.rbg != null) {
            return this.rbg;
        }
        BlockGraph bg = this.getBlockGraph();
        this.rbg = new HashReversibleGraph(bg);
        this.rbg.reverse();
        return this.rbg;
    }

    public DominatorsFinder getReverseDominatorsFinder() {
        if (this.rdFinder != null) {
            return this.rdFinder;
        }
        this.rdFinder = new SimpleDominatorsFinder(this.getReverseBlockGraph());
        return this.rdFinder;
    }

    public DominatorTree getReverseDominatorTree() {
        if (this.rdTree != null) {
            return this.rdTree;
        }
        this.rdTree = new DominatorTree(this.getReverseDominatorsFinder());
        return this.rdTree;
    }

    public DominanceFrontier getReverseDominanceFrontier() {
        if (this.rdFrontier != null) {
            return this.rdFrontier;
        }
        this.rdFrontier = new CytronDominanceFrontier(this.getReverseDominatorTree());
        return this.rdFrontier;
    }

    public BlockGraph getBlockGraph() {
        if (this.bg != null) {
            return this.bg;
        }
        this.bg = new ExceptionalBlockGraph((ExceptionalUnitGraph)this.getUnitGraph());
        BlockGraphConverter.addStartStopNodesTo(this.bg);
        return this.bg;
    }

    public UnitGraph getUnitGraph() {
        if (this.ug != null) {
            return this.ug;
        }
        this.ug = new ExceptionalUnitGraph(this.getBody());
        return this.ug;
    }

    public DominatorsFinder getDominatorsFinder() {
        if (this.dFinder != null) {
            return this.dFinder;
        }
        this.dFinder = new SimpleDominatorsFinder(this.getBlockGraph());
        return this.dFinder;
    }

    public DominatorTree getDominatorTree() {
        if (this.dTree != null) {
            return this.dTree;
        }
        this.dTree = new DominatorTree(this.getDominatorsFinder());
        return this.dTree;
    }

    public DominanceFrontier getDominanceFrontier() {
        if (this.dFrontier != null) {
            return this.dFrontier;
        }
        this.dFrontier = new CytronDominanceFrontier(this.getDominatorTree());
        return this.dFrontier;
    }

    public GlobalValueNumberer getGlobalValueNumberer() {
        if (this.gvn != null) {
            return this.gvn;
        }
        this.gvn = new SimpleGlobalValueNumberer(this.getBlockGraph());
        return this.gvn;
    }
}

