/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.G;
import soot.IdentityUnit;
import soot.Local;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.shimple.internal.SHashMultiMap;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.scalar.GuaranteedDefs;
import soot.toolkits.scalar.ValueUnitPair;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhiNodeManager {
    protected ShimpleBody body;
    protected ShimpleFactory sf;
    protected DominatorTree dt;
    protected DominanceFrontier df;
    protected BlockGraph cfg;
    protected GuaranteedDefs gd;
    protected MultiMap varToBlocks;
    protected Map<Unit, Block> unitToBlock;

    public PhiNodeManager(ShimpleBody body) {
        this.body = body;
        this.sf = G.v().shimpleFactory;
    }

    public void update() {
        this.gd = new GuaranteedDefs(this.sf.getUnitGraph());
        this.cfg = this.sf.getBlockGraph();
        this.dt = this.sf.getDominatorTree();
        this.df = this.sf.getDominanceFrontier();
    }

    public boolean insertTrivialPhiNodes() {
        this.update();
        boolean change = false;
        SHashMultiMap localsToDefPoints = new SHashMultiMap();
        this.varToBlocks = new HashMultiMap();
        for (Block block : this.cfg) {
            Iterator<Unit> unitsIt = block.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = unitsIt.next();
                List<ValueBox> defBoxes = unit.getDefBoxes();
                Iterator<ValueBox> defBoxesIt = defBoxes.iterator();
                while (defBoxesIt.hasNext()) {
                    Value def = defBoxesIt.next().getValue();
                    if (!(def instanceof Local)) continue;
                    localsToDefPoints.put(def, block);
                }
                if (!Shimple.isPhiNode(unit)) continue;
                this.varToBlocks.put(Shimple.getLhsLocal(unit), block);
            }
        }
        int[] workFlags = new int[this.cfg.size()];
        int iterCount = 0;
        Stack<Block> workList = new Stack<Block>();
        for (Local local : localsToDefPoints.keySet()) {
            ++iterCount;
            for (Block block : localsToDefPoints.get(local)) {
                workFlags[block.getIndexInMethod()] = iterCount;
                workList.push(block);
            }
            while (!workList.empty()) {
                Block block = (Block)workList.pop();
                DominatorNode node = this.dt.getDode(block);
                Iterator frontierNodes = this.df.getDominanceFrontierOf(node).iterator();
                while (frontierNodes.hasNext()) {
                    Block frontierBlock = (Block)((DominatorNode)frontierNodes.next()).getGode();
                    int fBIndex = frontierBlock.getIndexInMethod();
                    if (!this.needsPhiNode(local, frontierBlock)) continue;
                    this.prependTrivialPhiNode(local, frontierBlock);
                    change = true;
                    if (workFlags[fBIndex] >= iterCount) continue;
                    workFlags[fBIndex] = iterCount;
                    workList.push(frontierBlock);
                }
            }
        }
        return change;
    }

    public void prependTrivialPhiNode(Local local, Block frontierBlock) {
        List<Block> preds = frontierBlock.getPreds();
        PhiExpr pe = Shimple.v().newPhiExpr(local, preds);
        pe.setBlockId(frontierBlock.getIndexInMethod());
        AssignStmt trivialPhi = Jimple.v().newAssignStmt(local, pe);
        Unit blockHead = frontierBlock.getHead();
        if (blockHead instanceof IdentityUnit) {
            frontierBlock.insertAfter(trivialPhi, frontierBlock.getHead());
        } else {
            frontierBlock.insertBefore(trivialPhi, frontierBlock.getHead());
        }
        this.varToBlocks.put(local, frontierBlock);
    }

    protected boolean needsPhiNode(Local local, Block block) {
        if (this.varToBlocks.get(local).contains(block)) {
            return false;
        }
        Iterator<Unit> unitsIt = block.iterator();
        if (!unitsIt.hasNext()) {
            if (!block.getSuccs().isEmpty()) {
                throw new RuntimeException("Empty block in CFG?");
            }
            return false;
        }
        Unit unit = unitsIt.next();
        List definedLocals = this.gd.getGuaranteedDefs(unit);
        while (definedLocals == null) {
            if (!unitsIt.hasNext()) {
                throw new RuntimeException("Almost empty block in CFG?");
            }
            unit = unitsIt.next();
            definedLocals = this.gd.getGuaranteedDefs(unit);
        }
        return definedLocals.contains(local);
    }

    public void trimExceptionalPhiNodes() {
        HashSet<Unit> handlerUnits = new HashSet<Unit>();
        for (Trap trap : this.body.getTraps()) {
            handlerUnits.add(trap.getHandlerUnit());
        }
        for (Block block : this.cfg) {
            if (!handlerUnits.contains(block.getHead())) continue;
            Iterator<Unit> unitsIt = block.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = unitsIt.next();
                PhiExpr phi = Shimple.getPhiExpr(unit);
                if (phi == null) continue;
                this.trimPhiNode(phi);
            }
        }
    }

    public void trimPhiNode(PhiExpr phiExpr) {
        HashMultiMap valueToPairs = new HashMultiMap();
        for (ValueUnitPair argPair : phiExpr.getArgs()) {
            Value value = argPair.getValue();
            valueToPairs.put(value, argPair);
        }
        block1: for (Value value : valueToPairs.keySet()) {
            Set pairsSet = valueToPairs.get(value);
            ArrayList champs = new ArrayList(pairsSet);
            ArrayList challengers = new ArrayList(pairsSet);
            ValueUnitPair champ = (ValueUnitPair)champs.remove(0);
            Unit champU = champ.getUnit();
            boolean retry = true;
            while (retry) {
                retry = false;
                for (int i = 0; i < challengers.size(); ++i) {
                    ValueUnitPair challenger = (ValueUnitPair)challengers.get(i);
                    if (challenger.equals(champ)) continue;
                    Unit challengerU = challenger.getUnit();
                    if (this.dominates(champU, challengerU)) {
                        phiExpr.removeArg(challenger);
                        continue;
                    }
                    if (this.dominates(challengerU, champU)) {
                        phiExpr.removeArg(champ);
                        champ = challenger;
                        champU = champ.getUnit();
                        champs.remove(champ);
                        continue;
                    }
                    retry = true;
                }
                if (!retry) continue;
                if (champs.size() == 0) continue block1;
                champ = (ValueUnitPair)champs.remove(0);
                champU = champ.getUnit();
            }
        }
    }

    public boolean dominates(Unit champ, Unit challenger) {
        Block challengerBlock;
        Block champBlock;
        if (champ == null || challenger == null) {
            throw new RuntimeException("Assertion failed.");
        }
        if (champ.equals(challenger)) {
            return true;
        }
        if (this.unitToBlock == null) {
            this.unitToBlock = this.getUnitToBlockMap(this.cfg);
        }
        if ((champBlock = this.unitToBlock.get(champ)).equals(challengerBlock = this.unitToBlock.get(challenger))) {
            Iterator<Unit> unitsIt = champBlock.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = unitsIt.next();
                if (unit.equals(champ)) {
                    return true;
                }
                if (!unit.equals(challenger)) continue;
                return false;
            }
            throw new RuntimeException("Assertion failed.");
        }
        DominatorNode champNode = this.dt.getDode(champBlock);
        DominatorNode challengerNode = this.dt.getDode(challengerBlock);
        return this.dt.isDominatorOf(champNode, challengerNode);
    }

    public boolean doEliminatePhiNodes() {
        boolean addedNewLocals = false;
        ArrayList<Unit> phiNodes = new ArrayList<Unit>();
        ArrayList<AssignStmt> equivStmts = new ArrayList<AssignStmt>();
        ArrayList<ValueUnitPair> predBoxes = new ArrayList<ValueUnitPair>();
        PatchingChain<Unit> units = this.body.getUnits();
        for (Unit unit : units) {
            PhiExpr phi = Shimple.getPhiExpr(unit);
            if (phi == null) continue;
            Local lhsLocal = Shimple.getLhsLocal(unit);
            for (int i = 0; i < phi.getArgCount(); ++i) {
                Value phiValue = phi.getValue(i);
                AssignStmt convertedPhi = Jimple.v().newAssignStmt(lhsLocal, phiValue);
                equivStmts.add(convertedPhi);
                predBoxes.add(phi.getArgBox(i));
            }
            phiNodes.add(unit);
        }
        if (equivStmts.size() != predBoxes.size()) {
            throw new RuntimeException("Assertion failed.");
        }
        for (int i = 0; i < equivStmts.size(); ++i) {
            AssignStmt stmt = (AssignStmt)equivStmts.get(i);
            Unit pred = ((ValueUnitPair)predBoxes.get(i)).getUnit();
            if (pred == null) {
                throw new RuntimeException("Assertion failed.");
            }
            if (pred.branches()) {
                boolean needPriming = false;
                Local lhsLocal = (Local)stmt.getLeftOp();
                Local savedLocal = Jimple.v().newLocal(lhsLocal.getName() + "_", lhsLocal.getType());
                for (ValueBox useBox : pred.getUseBoxes()) {
                    if (!lhsLocal.equals(useBox.getValue())) continue;
                    needPriming = true;
                    addedNewLocals = true;
                    useBox.setValue(savedLocal);
                }
                if (needPriming) {
                    this.body.getLocals().add(savedLocal);
                    AssignStmt copyStmt = Jimple.v().newAssignStmt(savedLocal, lhsLocal);
                    units.insertBefore(copyStmt, pred);
                }
                units.insertBefore(stmt, pred);
                continue;
            }
            units.insertAfter(stmt, pred);
        }
        for (Unit removeMe : phiNodes) {
            units.remove(removeMe);
            removeMe.clearUnitBoxes();
        }
        return addedNewLocals;
    }

    public Map<Unit, Block> getUnitToBlockMap(BlockGraph blocks) {
        HashMap<Unit, Block> unitToBlock = new HashMap<Unit, Block>();
        for (Block block : blocks) {
            Iterator<Unit> unitsIt = block.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = unitsIt.next();
                unitToBlock.put(unit, block);
            }
        }
        return unitToBlock;
    }
}

