/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.tagkit.Host;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractHost
implements Host {
    private static final List<Tag> emptyList = Collections.emptyList();
    private List<Tag> mTagList = emptyList;

    @Override
    public List<Tag> getTags() {
        return this.mTagList;
    }

    @Override
    public void removeTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            this.mTagList.remove(tagIndex);
        }
    }

    private int searchForTag(String aName) {
        int i = 0;
        for (Tag tag : this.mTagList) {
            if (tag.getName().equals(aName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Tag getTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            return this.mTagList.get(tagIndex);
        }
        return null;
    }

    @Override
    public boolean hasTag(String aName) {
        return this.searchForTag(aName) != -1;
    }

    @Override
    public void addTag(Tag t) {
        if (this.mTagList == emptyList) {
            this.mTagList = new ArrayList<Tag>(1);
        }
        this.mTagList.add(t);
    }

    @Override
    public void removeAllTags() {
        this.mTagList = emptyList;
    }

    @Override
    public void addAllTagsOf(Host h) {
        for (Tag t : h.getTags()) {
            this.addTag(t);
        }
    }
}

