/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.astmetrics;

import java.io.OutputStream;
import polyglot.ast.ClassDecl;
import polyglot.ast.Node;
import polyglot.util.CodeWriter;
import polyglot.visit.NodeVisitor;
import soot.G;
import soot.toolkits.astmetrics.ClassData;
import soot.toolkits.astmetrics.MetricInterface;
import soot.toolkits.astmetrics.StmtSumWeightedByDepth;
import soot.toolkits.astmetrics.metricPrettyPrinter;

public abstract class ASTMetric
extends NodeVisitor
implements MetricInterface {
    Node astNode;
    String className = null;

    public ASTMetric(Node astNode) {
        this.astNode = astNode;
        this.reset();
    }

    public final NodeVisitor enter(Node n) {
        if (n instanceof ClassDecl) {
            this.className = ((ClassDecl)n).name();
            System.out.println("Starting processing: " + this.className);
        }
        return this;
    }

    public final Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (n instanceof ClassDecl) {
            if (this.className == null) {
                throw new RuntimeException("className is null");
            }
            System.out.println("Done with class " + this.className);
            ClassData data = this.getClassData();
            this.addMetrics(data);
            this.reset();
        }
        return this.leave(old, n, v);
    }

    public abstract void reset();

    public abstract void addMetrics(ClassData var1);

    public final void execute() {
        this.astNode.visit((NodeVisitor)this);
        System.out.println("\n\n\n PRETTY P{RINTING");
        if (this instanceof StmtSumWeightedByDepth) {
            metricPrettyPrinter p = new metricPrettyPrinter(this);
            p.printAst(this.astNode, new CodeWriter((OutputStream)System.out, 80));
        }
    }

    public void printAstMetric(Node n, CodeWriter w) {
    }

    public final ClassData getClassData() {
        if (this.className == null) {
            throw new RuntimeException("className is null");
        }
        for (ClassData tempData : G.v().ASTMetricsData) {
            if (!tempData.classNameEquals(this.className)) continue;
            return tempData;
        }
        ClassData data = new ClassData(this.className);
        G.v().ASTMetricsData.add(data);
        return data;
    }
}

