/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.List;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;

public class InitAnalysis
extends ForwardFlowAnalysis {
    FlowSet allLocals;

    public InitAnalysis(UnitGraph g) {
        super(g);
        Chain<Local> locs = g.getBody().getLocals();
        this.allLocals = new ArraySparseSet();
        for (Local loc : locs) {
            this.allLocals.add(loc);
        }
        this.doAnalysis();
    }

    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    protected Object newInitialFlow() {
        ArraySparseSet ret = new ArraySparseSet();
        this.allLocals.copy(ret);
        return ret;
    }

    protected void flowThrough(Object in, Object unit, Object out) {
        FlowSet inSet = (FlowSet)in;
        FlowSet outSet = (FlowSet)out;
        Unit s = (Unit)unit;
        inSet.copy(outSet);
        List<ValueBox> defBoxes = s.getDefBoxes();
        for (ValueBox defBox : defBoxes) {
            Value lhs = defBox.getValue();
            if (!(lhs instanceof Local)) continue;
            outSet.add(lhs);
        }
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet outSet = (FlowSet)out;
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

