/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.IntPair;
import soot.util.Chain;
import soot.util.Switchable;

class LocalDefsFlowAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet;
    Map<Local, BoundedFlowSet> localToPreserveSet;
    Map<Local, IntPair> localToIntPair;

    public LocalDefsFlowAnalysis(UnitGraph g) {
        super(g);
        if (Options.v().time()) {
            Timers.v().defsSetupTimer.start();
        }
        HashMap localToDefList = new HashMap(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        for (Local l : g.getBody().getLocals()) {
            localToDefList.put(l, new ArrayList());
        }
        for (Unit s : g) {
            List<ValueBox> defBoxes = s.getDefBoxes();
            if (defBoxes.isEmpty()) continue;
            if (defBoxes.size() != 1) {
                throw new RuntimeException("invalid number of def boxes");
            }
            if (!(defBoxes.get(0).getValue() instanceof Local)) continue;
            Local defLocal = (Local)defBoxes.get(0).getValue();
            List l = (List)localToDefList.get(defLocal);
            if (l == null) {
                throw new RuntimeException("local " + defLocal + " is used but not declared!");
            }
            l.add(s);
        }
        Iterator<Switchable> it = g.getBody().getLocals().iterator();
        LinkedList defList = new LinkedList();
        int startPos = 0;
        this.localToIntPair = new HashMap<Local, IntPair>(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        while (it.hasNext()) {
            Local l = (Local)it.next();
            Iterator jt = ((ArrayList)localToDefList.get(l)).iterator();
            int endPos = startPos - 1;
            while (jt.hasNext()) {
                defList.add(jt.next());
                ++endPos;
            }
            this.localToIntPair.put(l, new IntPair(startPos, endPos));
            startPos = endPos + 1;
        }
        Object[] defs = defList.toArray();
        ArrayFlowUniverse<Object> defUniverse = new ArrayFlowUniverse<Object>(defs);
        this.emptySet = new ArrayPackedSet(defUniverse);
        HashMap<Local, FlowSet> localToKillSet = new HashMap<Local, FlowSet>(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        this.localToPreserveSet = new HashMap<Local, BoundedFlowSet>(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        Chain<Local> locals = g.getBody().getLocals();
        for (Local l : locals) {
            localToKillSet.put(l, this.emptySet.clone());
        }
        for (Object element : defs) {
            Unit s = (Unit)element;
            List<ValueBox> defBoxes = s.getDefBoxes();
            if (defBoxes.size() != 1) {
                throw new RuntimeException("SimpleLocalDefs: invalid number of def boxes");
            }
            if (!(defBoxes.get(0).getValue() instanceof Local)) continue;
            Local defLocal = (Local)defBoxes.get(0).getValue();
            BoundedFlowSet killSet = (BoundedFlowSet)localToKillSet.get(defLocal);
            killSet.add(s, killSet);
        }
        for (Local l : locals) {
            BoundedFlowSet killSet = (BoundedFlowSet)localToKillSet.get(l);
            killSet.complement(killSet);
            this.localToPreserveSet.put(l, killSet);
        }
        if (Options.v().time()) {
            Timers.v().defsSetupTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().defsAnalysisTimer.start();
        }
        this.doAnalysis();
        if (Options.v().time()) {
            Timers.v().defsAnalysisTimer.end();
        }
    }

    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void flowThrough(Object inValue, Object d, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Unit unit = (Unit)d;
        List<ValueBox> defBoxes = unit.getDefBoxes();
        if (defBoxes.isEmpty()) {
            in.copy(out);
            return;
        }
        if (defBoxes.size() != 1) {
            throw new RuntimeException("SimpleLocalDefs: invalid number of def boxes");
        }
        Value value = defBoxes.get(0).getValue();
        if (value instanceof Local) {
            Local defLocal = (Local)value;
            in.intersection(this.localToPreserveSet.get(defLocal), out);
            out.add(unit, out);
            return;
        }
        in.copy(out);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }
}

