/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Node;
import polyglot.ext.jl.ast.TypeNode_c;
import polyglot.main.Options;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;
import polyglot.visit.TypedTranslator;

public class CanonicalTypeNode_c
extends TypeNode_c
implements CanonicalTypeNode {
    public CanonicalTypeNode_c(Position pos, Type type) {
        super(pos);
        this.type = type;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        if (this.type.isClass() && ((ct = this.type.toClass()).isTopLevel() || ct.isMember()) && !ts.classAccessible(ct, tc.context())) {
            throw new SemanticException("Cannot access class \"" + ct + "\" from the body of \"" + tc.context().currentClass() + "\".", this.position());
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.type.translate(null));
    }

    public void translate(CodeWriter w, Translator tr) {
        if (Options.global.fully_qualified_names || !(tr instanceof TypedTranslator)) {
            w.write(this.type.translate(null));
        } else {
            w.write(this.type.translate(((TypedTranslator)tr).context()));
        }
    }

    public String toString() {
        if (this.type == null) {
            return "<unknown-type>";
        }
        return ((Object)this.type).toString();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(type " + this.type + ")");
        w.end();
    }
}

