/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.jl.ast.Expr_c;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class New_c
extends Expr_c
implements New {
    protected Expr qualifier;
    protected TypeNode tn;
    protected List arguments;
    protected ClassBody body;
    protected ConstructorInstance ci;
    protected ParsedClassType anonType;

    public New_c(Position pos, Expr qualifier, TypeNode tn, List arguments, ClassBody body) {
        super(pos);
        this.qualifier = qualifier;
        this.tn = tn;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        this.body = body;
    }

    public Expr qualifier() {
        return this.qualifier;
    }

    public New qualifier(Expr qualifier) {
        New_c n = (New_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    public TypeNode objectType() {
        return this.tn;
    }

    public New objectType(TypeNode tn) {
        New_c n = (New_c)this.copy();
        n.tn = tn;
        return n;
    }

    public ParsedClassType anonType() {
        return this.anonType;
    }

    public New anonType(ParsedClassType anonType) {
        New_c n = (New_c)this.copy();
        n.anonType = anonType;
        return n;
    }

    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    public New constructorInstance(ConstructorInstance ci) {
        New_c n = (New_c)this.copy();
        n.ci = ci;
        return n;
    }

    public List arguments() {
        return this.arguments;
    }

    public ProcedureCall arguments(List arguments) {
        New_c n = (New_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    public ClassBody body() {
        return this.body;
    }

    public New body(ClassBody body) {
        New_c n = (New_c)this.copy();
        n.body = body;
        return n;
    }

    protected New_c reconstruct(Expr qualifier, TypeNode tn, List arguments, ClassBody body) {
        if (qualifier != this.qualifier || tn != this.tn || !CollectionUtil.equals(arguments, this.arguments) || body != this.body) {
            New_c n = (New_c)this.copy();
            n.tn = tn;
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild(this.qualifier, v);
        TypeNode tn = (TypeNode)this.visitChild(this.tn, v);
        List arguments = this.visitList(this.arguments, v);
        ClassBody body = (ClassBody)this.visitChild(this.body, v);
        return this.reconstruct(qualifier, tn, arguments, body);
    }

    public Context enterScope(Node child, Context c) {
        if (child == this.body && this.anonType != null && this.body != null) {
            c = c.pushClass(this.anonType, this.anonType);
        }
        return super.enterScope(child, c);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        if (this.body != null) {
            return tb.bypass(this.body);
        }
        return tb;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        New_c n = this;
        if (n.body() != null) {
            TypeBuilder bodyTB = (TypeBuilder)tb.visitChildren();
            bodyTB = bodyTB.pushAnonClass(this.position());
            n = (New_c)n.body((ClassBody)n.body().visit(bodyTB));
            ParsedClassType type = bodyTB.currentClass();
            n = (New_c)n.anonType(type);
        }
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(n.arguments.size());
        for (int i = 0; i < n.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), ts.Object(), Flags.NONE, l, Collections.EMPTY_LIST);
        n = (New_c)n.constructorInstance(ci);
        return n.type(ts.unknownType(this.position()));
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover ar) throws SemanticException {
        if (this.qualifier != null) {
            ar = (AmbiguityRemover)ar.bypass(this.tn);
        }
        if (this.body != null) {
            ar = (AmbiguityRemover)ar.bypass(this.body);
        }
        return ar;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (ar.kind() != AmbiguityRemover.ALL) {
            return this;
        }
        if (this.qualifier == null) {
            ClassType ct = this.tn.type().toClass();
            if (!ct.isMember() || ct.flags().isStatic()) {
                return this;
            }
            NodeFactory nf = ar.nodeFactory();
            TypeSystem ts = ar.typeSystem();
            Context c = ar.context();
            Object outer = null;
            String name = ct.name();
            ClassType t = c.currentClass();
            if (t == this.anonType) {
                t = t.outer();
            }
            while (t != null) {
                try {
                    t = ts.staticTarget(t).toClass();
                    ClassType mt = ts.findMemberClass(t, name, c.currentClass());
                    if (ts.equals(mt, ct)) {
                        outer = t;
                        break;
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
                t = t.outer();
            }
            if (outer == null) {
                throw new SemanticException("Could not find non-static member class \"" + name + "\".", this.position());
            }
            Special q = outer.equals(c.currentClass()) ? nf.This(this.position()) : nf.This(this.position(), nf.CanonicalTypeNode(this.position(), (Type)outer));
            return this.qualifier(q);
        }
        return this;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        if (this.qualifier != null) {
            tc = (TypeChecker)tc.bypass(this.tn);
        }
        if (this.body != null) {
            tc = (TypeChecker)tc.bypass(this.body);
        }
        return tc;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        New_c n = this;
        if (this.qualifier != null) {
            Type qt = this.qualifier.type();
            if (!qt.isClass()) {
                throw new SemanticException("Cannot instantiate member class of a non-class type.", this.qualifier.position());
            }
            TypeNode tn = this.disambiguateTypeNode(tc, qt.toClass());
            ClassType ct = tn.type().toClass();
            if (!ct.isInnerClass()) {
                throw new SemanticException("Cannot provide a containing instance for non-inner class " + ct.fullName() + ".", this.qualifier.position());
            }
            n = (New_c)n.objectType(tn);
        } else {
            ClassType ct = this.tn.type().toClass();
            if (ct.isMember()) {
                ClassType t = ct;
                while (t.isMember()) {
                    if (!t.flags().isStatic()) {
                        throw new SemanticException("Cannot allocate non-static member class \"" + t + "\".", this.position());
                    }
                    t = t.outer();
                }
            }
        }
        return n.typeCheckEpilogue(tc);
    }

    protected Node typeCheckEpilogue(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            argTypes.add(e.type());
        }
        ClassType ct = this.tn.type().toClass();
        if (this.body == null) {
            if (ct.flags().isInterface()) {
                throw new SemanticException("Cannot instantiate an interface.", this.position());
            }
            if (ct.flags().isAbstract()) {
                throw new SemanticException("Cannot instantiate an abstract class.", this.position());
            }
        } else {
            if (ct.flags().isFinal()) {
                throw new SemanticException("Cannot create an anonymous subclass of a final class.", this.position());
            }
            if (ct.flags().isInterface() && !this.arguments.isEmpty()) {
                throw new SemanticException("Cannot pass arguments to an anonymous class that implements an interface.", ((Expr)this.arguments.get(0)).position());
            }
        }
        if (!ct.flags().isInterface()) {
            Context c = tc.context();
            if (this.body != null) {
                this.anonType.superType(ct);
                c = c.pushClass(this.anonType, this.anonType);
            }
            this.ci = ts.findConstructor(ct, argTypes, c.currentClass());
        } else {
            this.ci = ts.defaultConstructor(this.position(), ct);
        }
        New_c n = (New_c)this.constructorInstance(this.ci).type(ct);
        if (n.body == null) {
            return n;
        }
        if (!ct.flags().isInterface()) {
            this.anonType.superType(ct);
        } else {
            this.anonType.superType(ts.Object());
            this.anonType.addInterface(ct);
        }
        this.anonType.inStaticContext(tc.context().inStaticContext());
        n = (New_c)n.type(this.anonType);
        ClassBody body = n.typeCheckBody(tc, ct);
        return n.body(body);
    }

    protected TypeNode partialDisambTypeNode(TypeNode tn, TypeChecker tc, ClassType outer) throws SemanticException {
        if (tn instanceof CanonicalTypeNode) {
            return tn;
        }
        String name = null;
        if (!(tn instanceof AmbTypeNode) || ((AmbTypeNode)tn).qual() != null) {
            throw new SemanticException("Cannot instantiate an member class.", tn.position());
        }
        name = ((AmbTypeNode)tn).name();
        TypeSystem ts = tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Context c = tc.context();
        ClassType ct = ts.findMemberClass(outer, name, c.currentClass());
        return nf.CanonicalTypeNode(tn.position(), ct);
    }

    protected TypeNode disambiguateTypeNode(TypeChecker tc, ClassType ct) throws SemanticException {
        TypeNode tn = this.partialDisambTypeNode(this.tn, tc, ct);
        if (tn instanceof CanonicalTypeNode) {
            return tn;
        }
        Job sj = tc.job().spawn(tc.context(), tn, Pass.CLEAN_SUPER, Pass.DISAM_ALL);
        if (!sj.status()) {
            if (!sj.reportedErrors()) {
                throw new SemanticException("Could not disambiguate type.", this.tn.position());
            }
            throw new SemanticException();
        }
        tn = (TypeNode)sj.ast();
        return (TypeNode)this.visitChild(tn, tc);
    }

    protected ClassBody typeCheckBody(TypeChecker tc, ClassType superType) throws SemanticException {
        Context bodyCtxt = tc.context().pushClass(this.anonType, this.anonType);
        Job sj = tc.job().spawn(bodyCtxt, this.body, Pass.CLEAN_SUPER, Pass.DISAM_ALL);
        if (!sj.status()) {
            if (!sj.reportedErrors()) {
                throw new SemanticException("Could not disambiguate body of anonymous " + (superType.flags().isInterface() ? "implementor" : "subclass") + " of \"" + superType + "\".");
            }
            throw new SemanticException();
        }
        ClassBody b = (ClassBody)sj.ast();
        TypeChecker bodyTC = (TypeChecker)tc.context(bodyCtxt);
        b = (ClassBody)this.visitChild(b, bodyTC.visitChildren());
        bodyTC.typeSystem().checkClassConformance(this.anonType());
        return b;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.qualifier) {
            ReferenceType t = this.ci.container();
            if (t.isClass() && t.toClass().isMember()) {
                t = t.toClass().container();
                return t;
            }
            return child.type();
        }
        Iterator i = this.arguments.iterator();
        Iterator j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = (Type)j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.ci == null) {
            throw new InternalCompilerError(this.position(), "Null constructor instance after type check.");
        }
        for (Type t : this.ci.throwTypes()) {
            ec.throwsException(t, this.position());
        }
        return super.exceptionCheck(ec);
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier.toString() + "." : "") + "new " + this.tn + "(...)" + (this.body != null ? " " + this.body : "");
    }

    protected void printQualifier(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
    }

    protected void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    protected void printBody(CodeWriter w, PrettyPrinter tr) {
        if (this.body != null) {
            w.write(" {");
            this.print(this.body, w, tr);
            w.write("}");
        }
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printQualifier(w, tr);
        w.write("new ");
        if (this.qualifier != null) {
            w.write(this.tn.name());
        } else {
            this.print(this.tn, w, tr);
        }
        this.printArgs(w, tr);
        this.printBody(w, tr);
    }

    public Term entry() {
        if (this.qualifier != null) {
            return this.qualifier.entry();
        }
        Term afterArgs = this;
        if (this.body() != null) {
            afterArgs = this.body();
        }
        return New_c.listEntry(this.arguments, afterArgs);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        Term afterArgs = this;
        if (this.body() != null) {
            afterArgs = this.body();
        }
        if (this.qualifier != null) {
            v.visitCFG((Term)this.qualifier, New_c.listEntry(this.arguments, afterArgs));
        }
        v.visitCFGList(this.arguments, afterArgs);
        if (this.body() != null) {
            v.visitCFG((Term)this.body(), this);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        LinkedList l = new LinkedList();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }
}

