/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.types;

import polyglot.ext.jl.types.Type_c;
import polyglot.types.PrimitiveType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;

public class PrimitiveType_c
extends Type_c
implements PrimitiveType {
    protected PrimitiveType.Kind kind;

    protected PrimitiveType_c() {
    }

    public PrimitiveType_c(TypeSystem ts, PrimitiveType.Kind kind) {
        super(ts);
        this.kind = kind;
    }

    public PrimitiveType.Kind kind() {
        return this.kind;
    }

    public String toString() {
        return this.kind.toString();
    }

    public String translate(Resolver c) {
        String s = this.kind.toString();
        return s;
    }

    public boolean isCanonical() {
        return true;
    }

    public boolean isPrimitive() {
        return true;
    }

    public PrimitiveType toPrimitive() {
        return this;
    }

    public boolean isVoid() {
        return this.kind == VOID;
    }

    public boolean isBoolean() {
        return this.kind == BOOLEAN;
    }

    public boolean isChar() {
        return this.kind == CHAR;
    }

    public boolean isByte() {
        return this.kind == BYTE;
    }

    public boolean isShort() {
        return this.kind == SHORT;
    }

    public boolean isInt() {
        return this.kind == INT;
    }

    public boolean isLong() {
        return this.kind == LONG;
    }

    public boolean isFloat() {
        return this.kind == FLOAT;
    }

    public boolean isDouble() {
        return this.kind == DOUBLE;
    }

    public boolean isIntOrLess() {
        return this.kind == CHAR || this.kind == BYTE || this.kind == SHORT || this.kind == INT;
    }

    public boolean isLongOrLess() {
        return this.isIntOrLess() || this.kind == LONG;
    }

    public boolean isNumeric() {
        return this.isLongOrLess() || this.kind == FLOAT || this.kind == DOUBLE;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public boolean equalsImpl(TypeObject t) {
        if (t instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)t;
            return this.kind() == p.kind();
        }
        return false;
    }

    public String wrapperTypeString(TypeSystem ts) {
        return ts.wrapperTypeString(this);
    }

    public String name() {
        return this.toString();
    }

    public String fullName() {
        return this.name();
    }

    public boolean descendsFromImpl(Type ancestor) {
        return false;
    }

    public boolean isImplicitCastValidImpl(Type toType) {
        if (!toType.isPrimitive()) {
            return false;
        }
        PrimitiveType t = toType.toPrimitive();
        PrimitiveType_c f = this;
        if (t.isVoid()) {
            return false;
        }
        if (f.isVoid()) {
            return false;
        }
        if (this.ts.equals(t, f)) {
            return true;
        }
        if (t.isBoolean()) {
            return f.isBoolean();
        }
        if (f.isBoolean()) {
            return false;
        }
        if (!f.isNumeric() || !t.isNumeric()) {
            return false;
        }
        if (t.isDouble()) {
            return true;
        }
        if (f.isDouble()) {
            return false;
        }
        if (t.isFloat()) {
            return true;
        }
        if (f.isFloat()) {
            return false;
        }
        if (t.isLong()) {
            return true;
        }
        if (f.isLong()) {
            return false;
        }
        if (t.isInt()) {
            return true;
        }
        if (f.isInt()) {
            return false;
        }
        if (t.isShort()) {
            return f.isShort() || f.isByte();
        }
        if (f.isShort()) {
            return false;
        }
        if (t.isChar()) {
            return f.isChar();
        }
        if (f.isChar()) {
            return false;
        }
        if (t.isByte()) {
            return f.isByte();
        }
        if (f.isByte()) {
            return false;
        }
        return false;
    }

    public boolean isCastValidImpl(Type toType) {
        if (this.isVoid() || toType.isVoid()) {
            return false;
        }
        if (this.ts.equals(this, toType)) {
            return true;
        }
        return this.isNumeric() && toType.isNumeric();
    }

    public boolean numericConversionValidImpl(long value) {
        return this.numericConversionValidImpl(new Long(value));
    }

    public boolean numericConversionValidImpl(Object value) {
        long v;
        if (value == null) {
            return false;
        }
        if (value instanceof Float || value instanceof Double) {
            return false;
        }
        if (value instanceof Number) {
            v = ((Number)value).longValue();
        } else if (value instanceof Character) {
            v = ((Character)value).charValue();
        } else {
            return false;
        }
        if (this.isLong()) {
            return true;
        }
        if (this.isInt()) {
            return Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE;
        }
        if (this.isChar()) {
            return 0L <= v && v <= 65535L;
        }
        if (this.isShort()) {
            return -32768L <= v && v <= 32767L;
        }
        if (this.isByte()) {
            return -128L <= v && v <= 127L;
        }
        return false;
    }
}

