/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.main.UsageError;
import polyglot.util.ErrorQueue;
import polyglot.util.QuotedStringTokenizer;
import polyglot.util.StdErrorQueue;

public class Main {
    private Set source;
    public static final String verbose = "verbose";
    private static Collection timeTopics = new ArrayList(1);

    protected ExtensionInfo getExtensionInfo(List args) throws TerminationException {
        ExtensionInfo ext = null;
        Iterator i = args.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (s.equals("-ext") || s.equals("-extension")) {
                if (ext != null) {
                    throw new TerminationException("only one extension can be specified");
                }
                i.remove();
                if (!i.hasNext()) {
                    throw new TerminationException("missing argument");
                }
                String extName = (String)i.next();
                i.remove();
                ext = Main.loadExtension("polyglot.ext." + extName + ".ExtensionInfo");
                continue;
            }
            if (!s.equals("-extclass")) continue;
            if (ext != null) {
                throw new TerminationException("only one extension can be specified");
            }
            i.remove();
            if (!i.hasNext()) {
                throw new TerminationException("missing argument");
            }
            String extClass = (String)i.next();
            i.remove();
            ext = Main.loadExtension(extClass);
        }
        if (ext != null) {
            return ext;
        }
        return Main.loadExtension("polyglot.ext.jl.ExtensionInfo");
    }

    public void start(String[] argv) throws TerminationException {
        this.start(argv, null);
    }

    public void start(String[] argv, ErrorQueue eq) throws TerminationException {
        Options options;
        this.source = new LinkedHashSet();
        List args = this.explodeOptions(argv);
        ExtensionInfo ext = this.getExtensionInfo(args);
        Options.global = options = ext.getOptions();
        try {
            argv = args.toArray(new String[0]);
            options.parseCommandLine(argv, this.source);
        }
        catch (UsageError ue) {
            PrintStream out;
            PrintStream printStream = out = ue.exitCode == 0 ? System.out : System.err;
            if (ue.getMessage() != null && ue.getMessage().length() > 0) {
                out.println(ext.compilerName() + ": " + ue.getMessage());
            }
            options.usage(out);
            throw new TerminationException(ue.exitCode);
        }
        if (eq == null) {
            eq = new StdErrorQueue(System.err, options.error_count, ext.compilerName());
        }
        Compiler compiler = new Compiler(ext, eq);
        long time0 = System.currentTimeMillis();
        if (!compiler.compile(this.source)) {
            throw new TerminationException(1);
        }
        if (Report.should_report(verbose, 1)) {
            Report.report(1, "Output files: " + compiler.outputFiles());
        }
        long start_time = System.currentTimeMillis();
        if (!this.invokePostCompiler(options, compiler, eq)) {
            throw new TerminationException(1);
        }
        if (Report.should_report(verbose, 1)) {
            Main.reportTime("Finished compiling Java output files. time=" + (System.currentTimeMillis() - start_time), 1);
            Main.reportTime("Total time=" + (System.currentTimeMillis() - time0), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokePostCompiler(Options options, Compiler compiler, ErrorQueue eq) {
        if (options.post_compiler != null && !options.output_stdout) {
            Runtime runtime = Runtime.getRuntime();
            QuotedStringTokenizer st = new QuotedStringTokenizer(options.post_compiler);
            int pc_size = st.countTokens();
            String[] javacCmd = new String[pc_size + 2 + compiler.outputFiles().size()];
            int j = 0;
            for (int i = 0; i < pc_size; ++i) {
                javacCmd[j++] = st.nextToken();
            }
            javacCmd[j++] = "-classpath";
            javacCmd[j++] = options.constructPostCompilerClasspath();
            Iterator iter = compiler.outputFiles().iterator();
            while (iter.hasNext()) {
                javacCmd[j] = (String)iter.next();
                ++j;
            }
            if (Report.should_report(verbose, 1)) {
                StringBuffer cmdStr = new StringBuffer();
                for (int i = 0; i < javacCmd.length; ++i) {
                    cmdStr.append(javacCmd[i] + " ");
                }
                Report.report(1, "Executing post-compiler " + cmdStr);
            }
            try {
                Process proc = runtime.exec(javacCmd);
                InputStreamReader err = null;
                try {
                    int len;
                    err = new InputStreamReader(proc.getErrorStream());
                    char[] c = new char[72];
                    StringBuffer sb = new StringBuffer();
                    while ((len = err.read(c)) > 0) {
                        sb.append(String.valueOf(c, 0, len));
                    }
                    if (sb.length() != 0) {
                        eq.enqueue(6, sb.toString());
                    }
                }
                finally {
                    err.close();
                }
                proc.waitFor();
                if (!options.keep_output_files) {
                    String[] rmCmd = new String[1 + compiler.outputFiles().size()];
                    rmCmd[0] = "rm";
                    for (int i = 1; i < rmCmd.length; ++i) {
                        rmCmd[i] = javacCmd[i + 2];
                    }
                    runtime.exec(rmCmd);
                }
                if (proc.exitValue() > 0) {
                    eq.enqueue(6, "Non-zero return code: " + proc.exitValue());
                    return false;
                }
            }
            catch (Exception e) {
                eq.enqueue(6, e.getMessage());
                return false;
            }
        }
        return true;
    }

    private List explodeOptions(String[] args) throws TerminationException {
        LinkedList ll = new LinkedList();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("@")) {
                String fn = args[i].substring(1);
                try {
                    String l;
                    BufferedReader lr = new BufferedReader(new FileReader(fn));
                    LinkedList<String> newArgs = new LinkedList<String>();
                    while ((l = lr.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(l, " ");
                        while (st.hasMoreTokens()) {
                            newArgs.add(st.nextToken());
                        }
                    }
                    lr.close();
                    ll.addAll(newArgs);
                    continue;
                }
                catch (IOException e) {
                    throw new TerminationException("cmdline parser: couldn't read args file " + fn);
                }
            }
            ll.add(args[i]);
        }
        return ll;
    }

    public static final void main(String[] args) {
        try {
            new Main().start(args);
        }
        catch (TerminationException te) {
            if (te.getMessage() != null) {
                (te.exitCode == 0 ? System.out : System.err).println(te.getMessage());
            }
            System.exit(te.exitCode);
        }
    }

    static final ExtensionInfo loadExtension(String ext) throws TerminationException {
        if (ext != null && !ext.equals("")) {
            Class<?> extClass = null;
            try {
                extClass = Class.forName(ext);
            }
            catch (ClassNotFoundException e) {
                throw new TerminationException("Extension " + ext + " not found: could not find class " + ext + ".");
            }
            try {
                return (ExtensionInfo)extClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new TerminationException(ext + " is not a valid polyglot extension:" + " extension class " + ext + " exists but is not a subclass of ExtensionInfo");
            }
            catch (Exception e) {
                throw new TerminationException("Extension " + ext + " could not be loaded: could not instantiate " + ext + ".");
            }
        }
        return null;
    }

    private static void reportTime(String msg, int level) {
        Report.report(level, msg);
    }

    static {
        timeTopics.add("time");
    }

    public static class TerminationException
    extends RuntimeException {
        public final int exitCode;

        public TerminationException(String msg) {
            this(msg, 1);
        }

        public TerminationException(int exit) {
            this.exitCode = exit;
        }

        public TerminationException(String msg, int exit) {
            super(msg);
            this.exitCode = exit;
        }
    }
}

