/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.InvalidClassException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.BadSerializationException;
import polyglot.types.CachingResolver;
import polyglot.types.ClassResolver;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.ClassPathLoader;
import polyglot.util.CollectionUtil;
import polyglot.util.TypeEncoder;

public class LoadedClassResolver
extends ClassResolver
implements TopLevelResolver {
    protected static final int NOT_COMPATIBLE = -1;
    protected static final int MINOR_NOT_COMPATIBLE = 1;
    protected static final int COMPATIBLE = 0;
    protected TypeSystem ts;
    protected TypeEncoder te;
    protected ClassPathLoader loader;
    protected Version version;
    protected Set nocache;
    protected boolean allowRawClasses;
    protected static final Collection report_topics = CollectionUtil.list("types", "resolver", "loader");

    public LoadedClassResolver(TypeSystem ts, String classpath, ClassFileLoader loader, Version version2, boolean allowRawClasses) {
        this.ts = ts;
        this.te = new TypeEncoder(ts);
        this.loader = new ClassPathLoader(classpath, loader);
        this.version = version2;
        this.nocache = new HashSet();
        this.allowRawClasses = allowRawClasses;
    }

    public boolean packageExists(String name) {
        return this.loader.packageExists(name);
    }

    protected ClassFile loadFile(String name) {
        block6: {
            if (this.nocache.contains(name)) {
                return null;
            }
            try {
                ClassFile clazz = this.loader.loadClass(name);
                if (clazz == null) {
                    if (Report.should_report(report_topics, 4)) {
                        Report.report(4, "Class " + name + " not found in classpath " + this.loader.classpath());
                    }
                    break block6;
                }
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " found in classpath " + this.loader.classpath());
                }
                return clazz;
            }
            catch (ClassFormatError e) {
                if (!Report.should_report(report_topics, 4)) break block6;
                Report.report(4, "Class " + name + " format error");
            }
        }
        this.nocache.add(name);
        return null;
    }

    public Named find(String name) throws SemanticException {
        ClassFile clazz;
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "LoadedCR.find(" + name + ")");
        }
        if ((clazz = this.loadFile(name)) == null) {
            throw new NoClassException(name);
        }
        if (clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            return this.getEncodedType(clazz, name);
        }
        if (this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            return clazz.type(this.ts);
        }
        throw new SemanticException("Unable to find a suitable definition of \"" + name + "\". A class file was found," + " but it did not contain appropriate information for this" + " language extension. If the source for this file is written" + " in the language extension, try recompiling the source code.");
    }

    protected ClassType getEncodedType(ClassFile clazz, String name) throws SemanticException {
        ClassType dt;
        int comp = this.checkCompilerVersion(clazz.compilerVersion(this.version.name()));
        if (comp == -1) {
            throw new SemanticException("Unable to find a suitable definition of " + clazz.name() + ". Try recompiling or obtaining " + " a newer version of the class file.");
        }
        try {
            dt = (ClassType)this.te.decode(clazz.encodedClassType(this.version.name()));
        }
        catch (InvalidClassException e) {
            throw new BadSerializationException(clazz.name());
        }
        ((CachingResolver)this.ts.systemResolver()).addNamed(name, dt);
        if (Report.should_report(report_topics, 2)) {
            Report.report(2, "Returning serialized ClassType for " + clazz.name() + ".");
        }
        return dt;
    }

    protected int checkCompilerVersion(String clazzVersion) {
        if (clazzVersion == null) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(clazzVersion, ".");
        try {
            int v = Integer.parseInt(st.nextToken());
            Version version2 = this.version;
            if (v != version2.major()) {
                return -1;
            }
            v = Integer.parseInt(st.nextToken());
            if (v != version2.minor()) {
                return 1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return 0;
    }
}

