/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import polyglot.util.AllowBreak;
import polyglot.util.BlockItem;
import polyglot.util.Item;
import polyglot.util.MaxLevels;
import polyglot.util.Newline;
import polyglot.util.Overrun;
import polyglot.util.TextItem;

public class CodeWriter {
    protected BlockItem input;
    protected BlockItem current;
    protected static Item top;
    protected PrintWriter output;
    protected int width;
    protected static int format_calls;
    public static final boolean debug = false;
    public static final boolean showInput = false;
    public static final boolean visualize = false;
    public static final boolean precompute = true;
    protected int trace_indent = 0;

    public CodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public CodeWriter(PrintWriter o, int width_) {
        this.output = o;
        this.width = width_;
        this.current = this.input = new BlockItem(null, 0);
    }

    public CodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    public void write(String s) {
        if (s.length() > 0) {
            this.write(s, s.length());
        }
    }

    public void write(String s, int length) {
        this.current.add(new TextItem(s, length));
    }

    public void begin(int n) {
        BlockItem b = new BlockItem(this.current, n);
        this.current.add(b);
        this.current = b;
    }

    public void end() {
        this.current = this.current.parent;
    }

    public void allowBreak(int n) {
        this.allowBreak(n, 1, "", 1);
    }

    public void allowBreak(int n, String alt) {
        this.allowBreak(n, 1, alt, 1);
    }

    public void allowBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, false));
    }

    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.current.add(new AllowBreak(n, level, alt, altlen, true));
    }

    public void newline() {
        this.newline(0, 1);
    }

    public void newline(int n, int level) {
        this.current.add(new Newline(n, level));
    }

    public void newline(int n) {
        this.newline(n, 1);
    }

    public boolean flush() throws IOException {
        return this.flush(true);
    }

    public boolean flush(boolean format) throws IOException {
        boolean success = true;
        format_calls = 0;
        if (format) {
            try {
                top = this.input;
                Item.format(this.input, 0, 0, this.width, this.width, new MaxLevels(Integer.MAX_VALUE, Integer.MAX_VALUE), 0, 0);
            }
            catch (Overrun o) {
                success = false;
            }
        } else {
            success = false;
        }
        this.input.sendOutput(this.output, 0, 0, success, null);
        this.output.flush();
        this.current = this.input = new BlockItem(null, 0);
        return success;
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    public String toString() {
        return this.input.toString();
    }

    void incIndent() {
        ++this.trace_indent;
    }

    void decIndent() {
        --this.trace_indent;
        if (this.trace_indent < 0) {
            throw new RuntimeException("unmatched end");
        }
    }

    void trace(String s) {
        for (int i = 0; i < this.trace_indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(s);
    }

    static {
        format_calls = 0;
    }
}

