/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.frontend.TargetFactory;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Package;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.visit.HeaderTranslator;
import polyglot.visit.TypedTranslator;

public class CppTranslator
extends TypedTranslator {
    protected Context context;
    protected static HashMap createdFiles = new HashMap();

    public CppTranslator(Job job, TypeSystem ts, NodeFactory nf, TargetFactory tf) {
        super(job, ts, nf, tf);
    }

    protected static boolean cppBackend() {
        return false;
    }

    public static HashMap getFileNames() {
        return createdFiles;
    }

    public HeaderTranslator headerContext(Context c) {
        HeaderTranslator ht = new HeaderTranslator(this);
        ht.context = c;
        return ht;
    }

    public static String cScope(String s) {
        String out = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            out = c == '.' ? out + "::" : out + c;
        }
        return out;
    }

    public String cTypeString(Type type) {
        PrimitiveType pt;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            String s = "jmatch_array< " + this.cTypeString(at.base());
            if (at.base().isReference()) {
                s = s + "*";
            }
            return s + " > ";
        }
        if (type instanceof ClassType) {
            ClassType ct = (ClassType)type;
            if (ct.isTopLevel() && ct.package_() != null) {
                return CppTranslator.cScope(ct.package_().translate(this.context) + "." + ct.name());
            }
        } else if (type instanceof PrimitiveType && (pt = (PrimitiveType)type).kind() == PrimitiveType.BOOLEAN) {
            return "bool";
        }
        return type.translate(this.context);
    }

    public void print(Node parent, Node child, CodeWriter w) {
        if (CppTranslator.cppBackend() && child instanceof TypeNode) {
            TypeNode tn = (TypeNode)child;
            Type type = tn.type();
            w.write(this.cTypeString(type));
        }
        super.print(parent, child, w);
    }

    protected boolean translateSource(SourceFile sfn) {
        TypeSystem ts = this.typeSystem();
        NodeFactory nf = this.nodeFactory();
        TargetFactory tf = this.tf;
        int outputWidth = this.job.compiler().outputWidth();
        Collection outputFiles = this.job.compiler().outputFiles();
        List exports = this.exports(sfn);
        try {
            File of;
            Writer headerWriter = null;
            CodeWriter wH = null;
            String pkg = "";
            if (sfn.package_() != null) {
                Package p = sfn.package_().package_();
                pkg = p.toString();
            }
            TopLevelDecl first = null;
            if (exports.size() == 0) {
                of = tf.outputFile(pkg, sfn.source());
            } else {
                first = (TopLevelDecl)exports.get(0);
                of = tf.outputFile(pkg, first.name(), sfn.source());
            }
            String opfPath = of.getPath();
            if (!opfPath.endsWith("$")) {
                outputFiles.add(of.getPath());
            }
            Writer ofw = tf.outputWriter(of);
            CodeWriter w = new CodeWriter(ofw, outputWidth);
            createdFiles.put(of.getPath(), null);
            if (CppTranslator.cppBackend()) {
                File headerFile = new File(tf.headerNameForFileName(of.getPath()));
                headerWriter = tf.outputWriter(headerFile);
                wH = new CodeWriter(headerWriter, outputWidth);
                String className = null;
                if (!exports.isEmpty()) {
                    first = (TopLevelDecl)exports.get(0);
                    className = first.name();
                } else {
                    String name = sfn.source().name();
                    className = name.substring(0, name.lastIndexOf(46));
                }
                this.writeHFileHeader(sfn, className, wH);
            }
            this.writeHeader(sfn, w);
            Iterator i = sfn.decls().iterator();
            while (i.hasNext()) {
                TopLevelDecl decl = (TopLevelDecl)i.next();
                if (decl.flags().isPublic() && decl != first && !CppTranslator.cppBackend()) {
                    w.flush();
                    ofw.close();
                    of = tf.outputFile(pkg, decl.name(), sfn.source());
                    outputFiles.add(of.getPath());
                    ofw = tf.outputWriter(of);
                    w = new CodeWriter(ofw, outputWidth);
                    this.writeHeader(sfn, w);
                }
                this.translateTopLevelDecl(w, sfn, decl);
                if (CppTranslator.cppBackend()) {
                    Context c = sfn.enterScope(decl, this.context);
                    decl.del().translate(wH, this.headerContext(c));
                }
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            this.writeFooter(sfn, w);
            if (CppTranslator.cppBackend()) {
                this.writeHFileFooter(sfn, wH);
                wH.flush();
                headerWriter.close();
            }
            w.flush();
            ofw.close();
            return true;
        }
        catch (IOException e) {
            this.job.compiler().errorQueue().enqueue(2, "I/O error while translating: " + e.getMessage());
            return false;
        }
    }

    protected void writeHFileHeader(SourceFile sfn, String className, CodeWriter w) {
        String pkg = null;
        if (sfn.package_() != null) {
            Package p = sfn.package_().package_();
            pkg = p.fullName();
        }
        if (pkg == null || pkg.equals("")) {
            pkg = "jmatch_primary";
        }
        String macroName = "_" + CppTranslator.macroEscape(pkg) + "_" + CppTranslator.macroEscape(className) + "_H";
        w.write("#ifndef " + macroName);
        w.newline(0);
        w.write("#define " + macroName);
        w.newline(0);
        if (sfn.package_() != null) {
            sfn.package_().del().translate(w, this);
        } else {
            w.write("namespace " + CppTranslator.cScope(pkg) + " {");
        }
        w.newline(0);
        w.write("using namespace jmatch_primary;");
        w.newline(0);
        w.write("using namespace java::lang;");
        w.newline(0);
        for (Import imp : sfn.imports()) {
            imp.del().translate(w, this);
            w.newline(0);
        }
    }

    protected void writeHFileFooter(SourceFile sfn, CodeWriter w) {
        int packageDepth = 0;
        if (null != sfn.package_()) {
            int i;
            Package p = sfn.package_().package_();
            String pkgName = p.toString();
            if (pkgName.length() > 0) {
                ++packageDepth;
            }
            for (i = 0; i < pkgName.length(); ++i) {
                if (pkgName.charAt(i) != '.') continue;
                ++packageDepth;
            }
            w.write("/* closing namespace */");
            w.newline(0);
            for (i = 0; i < packageDepth; ++i) {
                w.write("}");
            }
            w.newline(0);
            w.newline(0);
        }
        if (packageDepth == 0) {
            w.newline(0);
            w.write("} /* namespace */");
            w.newline(0);
            w.newline(0);
        }
        w.write("#endif");
        w.newline(0);
        w.newline(0);
    }

    protected void writeFooter(SourceFile sfn, CodeWriter w) {
        if (CppTranslator.cppBackend()) {
            int packageDepth = 0;
            if (null != sfn.package_()) {
                int i;
                Package p = sfn.package_().package_();
                String pkgName = p.toString();
                if (pkgName.length() > 0) {
                    ++packageDepth;
                }
                for (i = 0; i < pkgName.length(); ++i) {
                    if (pkgName.charAt(i) != '.') continue;
                    ++packageDepth;
                }
                w.write("/* closing namespace */");
                w.newline(0);
                for (i = 0; i < packageDepth; ++i) {
                    w.write("}");
                }
                w.newline(0);
                w.newline(0);
            }
            if (packageDepth == 0) {
                w.newline(0);
                w.write("} /* namespace */");
                w.newline(0);
                w.newline(0);
            }
        }
    }

    protected void writeHeader(SourceFile sfn, CodeWriter w) {
        if (CppTranslator.cppBackend()) {
            String pkg = "";
            if (sfn.package_() != null) {
                Package p = sfn.package_().package_();
                pkg = p.toString() + ".";
            }
            int i = 0;
            int dots = 0;
            for (i = 0; i < pkg.length(); ++i) {
                if (pkg.charAt(i) != '.') continue;
                ++dots;
            }
            w.write("#include\"");
            for (i = 0; i < dots; ++i) {
                w.write("../");
            }
            w.write("mainproj.h\"");
            w.newline(0);
            if (null != sfn.package_()) {
                sfn.package_().del().translate(w, this);
                w.newline(0);
                w.newline(0);
            } else {
                w.write("namespace jmatch_primary {");
                w.newline(0);
                w.newline(0);
            }
            w.write("using namespace jmatch_primary;");
            w.newline(0);
            w.write("using namespace java::lang;");
            w.newline(0);
            for (Import imp : sfn.imports()) {
                imp.del().translate(w, this);
                w.newline(0);
            }
        } else {
            if (sfn.package_() != null) {
                w.write("package ");
                sfn.package_().del().translate(w, this);
                w.write(";");
                w.newline(0);
                w.newline(0);
            }
            boolean newline = false;
            for (Import imp : sfn.imports()) {
                imp.del().translate(w, this);
                newline = true;
            }
            if (newline) {
                w.newline(0);
            }
        }
    }
}

