/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.IdentityKey;
import polyglot.visit.DataFlow;

public class FlowGraph {
    protected Map peerMap;
    protected Term root;
    protected boolean forward;
    public static final EdgeKey EDGE_KEY_TRUE = new EdgeKey("true");
    public static final EdgeKey EDGE_KEY_FALSE = new EdgeKey("false");
    public static final EdgeKey EDGE_KEY_OTHER = new EdgeKey("");

    FlowGraph(Term root, boolean forward) {
        this.root = root;
        this.forward = forward;
        this.peerMap = new HashMap();
    }

    public Term startNode() {
        return this.forward ? this.root.entry() : this.root;
    }

    public Term finishNode() {
        return this.forward ? this.root : this.root.entry();
    }

    public Term entryNode() {
        return this.root.entry();
    }

    public Term exitNode() {
        return this.root;
    }

    public Term root() {
        return this.root;
    }

    public boolean forward() {
        return this.forward;
    }

    public Collection pathMaps() {
        return this.peerMap.values();
    }

    public Map pathMap(Node n) {
        return (Map)this.peerMap.get(new IdentityKey(n));
    }

    public Collection peers() {
        ArrayList c = new ArrayList();
        for (Map m : this.peerMap.values()) {
            Iterator j = m.values().iterator();
            while (j.hasNext()) {
                c.add(j.next());
            }
        }
        return c;
    }

    public Peer peer(Term n, DataFlow df) {
        return this.peer(n, Collections.EMPTY_LIST, df);
    }

    public Collection peers(Term n) {
        IdentityKey k = new IdentityKey(n);
        Map pathMap = (Map)this.peerMap.get(k);
        if (pathMap == null) {
            return Collections.EMPTY_LIST;
        }
        return pathMap.values();
    }

    public Peer peer(Term n, List path_to_finally, DataFlow df) {
        ListKey lk;
        Peer p;
        IdentityKey k = new IdentityKey(n);
        HashMap<ListKey, Peer> pathMap = (HashMap<ListKey, Peer>)this.peerMap.get(k);
        if (pathMap == null) {
            pathMap = new HashMap<ListKey, Peer>();
            this.peerMap.put(k, pathMap);
        }
        if ((p = (Peer)pathMap.get(lk = new ListKey(path_to_finally))) == null) {
            p = new Peer(n, path_to_finally);
            pathMap.put(lk, p);
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set todo = new HashSet(this.peers());
        LinkedList<Peer> queue = new LinkedList<Peer>(this.peers(this.startNode()));
        while (!queue.isEmpty()) {
            Peer p = (Peer)queue.removeFirst();
            todo.remove(p);
            sb.append(p.node + " (" + p.node.position() + ")\n");
            for (Edge e : p.succs) {
                Peer q = e.getTarget();
                sb.append("    -> " + q.node + " (" + q.node.position() + ")\n");
                if (!todo.contains(q) || queue.contains(q)) continue;
                queue.addLast(q);
            }
            if (!queue.isEmpty() || todo.isEmpty()) continue;
            sb.append("\n\n***UNREACHABLE***\n");
            queue.addAll(todo);
            todo = Collections.EMPTY_SET;
        }
        return sb.toString();
    }

    protected static class ListKey {
        protected List list;

        ListKey(List list) {
            this.list = list;
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ListKey) {
                ListKey k = (ListKey)other;
                return CollectionUtil.equals(this.list, k.list);
            }
            return false;
        }
    }

    public static class Peer {
        protected DataFlow.Item inItem;
        protected Map outItems;
        protected Term node;
        protected List succs;
        protected List preds;
        protected List path_to_finally;
        private Set succEdgeKeys;

        public Peer(Term node, List path_to_finally) {
            this.node = node;
            this.path_to_finally = path_to_finally;
            this.inItem = null;
            this.outItems = null;
            this.succs = new ArrayList();
            this.preds = new ArrayList();
            this.succEdgeKeys = null;
        }

        public List succs() {
            return this.succs;
        }

        public List preds() {
            return this.preds;
        }

        public Term node() {
            return this.node;
        }

        public DataFlow.Item inItem() {
            return this.inItem;
        }

        public DataFlow.Item outItem(EdgeKey key) {
            return (DataFlow.Item)this.outItems.get(key);
        }

        public String toString() {
            return this.node + "[" + this.hashCode() + ": " + this.path_to_finally + "]";
        }

        public Set succEdgeKeys() {
            if (this.succEdgeKeys == null) {
                this.succEdgeKeys = new HashSet();
                for (Edge e : this.succs) {
                    this.succEdgeKeys.add(e.getKey());
                }
                if (this.succEdgeKeys.isEmpty()) {
                    this.succEdgeKeys.add(EDGE_KEY_OTHER);
                }
            }
            return this.succEdgeKeys;
        }
    }

    public static class Edge {
        protected EdgeKey key;
        protected Peer target;

        protected Edge(EdgeKey key, Peer target) {
            this.key = key;
            this.target = target;
        }

        public EdgeKey getKey() {
            return this.key;
        }

        public Peer getTarget() {
            return this.target;
        }

        public String toString() {
            return "(" + this.key + ")" + this.target;
        }
    }

    public static class ExceptionEdgeKey
    extends EdgeKey {
        public ExceptionEdgeKey(Type t) {
            super(t);
        }

        public Type type() {
            return (Type)this.o;
        }

        public String toString() {
            return this.type().isClass() ? this.type().toClass().name() : ((Object)this.type()).toString();
        }
    }

    public static class EdgeKey {
        protected Object o;

        protected EdgeKey(Object o) {
            this.o = o;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof EdgeKey && ((EdgeKey)other).o.equals(this.o);
        }

        public String toString() {
            return this.o.toString();
        }
    }
}

