package dfatool.expressions;

import dfatool.strategy.elements.Context;



public abstract class BinaryExpression extends Expression{
	
	protected Expression lExp;
	protected Expression rExp;
	
	public BinaryExpression(Expression lExp, Expression rExp) {
		this.lExp = lExp;
		this.rExp = rExp;
		this.type = TypeConstants.BOOL;
	}

	public Expression getlExp() {
		return lExp;
	}

	public void setlExp(Expression lExp) {
		this.lExp = lExp;
	}

	public Expression getrExp() {
		return rExp;
	}

	public void setrExp(Expression rExp) {
		this.rExp = rExp;
	}
	
	@Override
	public boolean checkType(Context c) {
		return lExp.checkType(c) && rExp.checkType(c) && rExp.getType().equals(lExp.getType());
	}

}
