package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.BoolValue;
import dfatool.values.Value;

public class ConditionalExpression extends Expression {

	Expression bExp,exp1,exp2;
	
	
	public ConditionalExpression(Expression bExp, Expression exp1,
			Expression exp2) {
		this.bExp = bExp;
		this.exp1 = exp1;
		this.exp2 = exp2;
	}

	@Override
	public Value evaluate(Context c) {
		BoolValue b = (BoolValue) bExp.evaluate(c);
		if (b.getValue())
			return exp1.evaluate(c);
		else
			return exp2.evaluate(c);
	}

	@Override
	public boolean checkType(Context c) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public String toConcreteSyntax() {
		return "if "+bExp.toConcreteSyntax()+" then "+exp1.toConcreteSyntax()+" else "+exp2.toConcreteSyntax();
	}

}
