package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.BoolValue;
import dfatool.values.Value;

public class DifferentExpression extends BinaryExpression{

	public DifferentExpression(Expression lExp, Expression rExp) {
		// TODO Auto-generated constructor stub
		super(lExp, rExp);
		this.type = TypeConstants.BOOL;
	}

	@Override
	public Value evaluate(Context c) {
		return new BoolValue(!getlExp().evaluate(c).equals(getrExp().evaluate(c)));
	}
	
	@Override
	public String toConcreteSyntax(){
		return this.lExp.toConcreteSyntax()+" != "+this.rExp.toConcreteSyntax();
	}


}
