package dfatool.expressions;

import java.security.acl.LastOwnerException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import dfatool.strategy.elements.Context;
import dfatool.values.ListValue;
import dfatool.values.SetValue;
import dfatool.values.Value;

public class EnumExpression extends ListExpression{

	List<Expression> elements;
	
	public EnumExpression(List<Expression> elements) {
		this.elements = elements;
		this.type = TypeConstants.SETENUM;
	}

	@Override
	public Value evaluate(Context c) {
		ListValue s = new ListValue();
		for(Expression e: elements) 
			s.add(e.evaluate(c));
		return s;
	}
	
//	@Override
//	public String toString() {
//		for(Expression e : ){
//			
//		}
//		return "";
//	}

	@Override
	public boolean checkType(Context c) {
		boolean setWellTyped = true;
		Iterator<Expression> i = elements.iterator();
		while(setWellTyped && i.hasNext()) setWellTyped = i.next().checkType(c);
		if (!setWellTyped) return false;
		return true;
	}
	
	@Override
	public String toConcreteSyntax() {
		String s = "< ";
		for(Expression e : this.elements)
			s += e.toConcreteSyntax()+",";
		return s.substring(0, s.length()-1)+" >";
	}

}
