package dfatool.expressions;

import java.util.Iterator;

import dfatool.strategy.elements.Context;
import dfatool.values.StringValue;
import dfatool.values.Value;

public class Id extends UnaryExpression{
	String id;

	public Id(String id) {
		this.id = id;
		this.type = TypeConstants.ID;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	@Override
	public String toConcreteSyntax() {
		return id;
	}

	@Override
	public Value evaluate(Context c) {
		if (c.getTypeMap().containsKey(getId())) return (Value) c.getTypeMap().get(getId());
		else if (c.getVarMap().containsKey(getId())) return c.getVarMap().get(getId());
		return new dfatool.values.StringValue(getId());
	}

	@Override
	public boolean checkType(Context c) {
		Iterator<String> i = c.getTypeMap().keySet().iterator(); 
		boolean found = false;
		while(i.hasNext() && !found){
			String type = i.next();
			found = c.getTypeMap().get(type).contains(new StringValue(this.id));
			setType(type);
		}
		return true;
	}

}
