package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.IntValue;
import dfatool.values.Value;

public class IntExpression extends UnaryExpression{
	Integer i;
	
	public IntExpression(Integer i) {
		this.i = i;
		this.type = TypeConstants.INT;
	}
	
	@Override
	public String toConcreteSyntax() {
		return i.toString();
	}

	@Override
	public Value evaluate(Context c) {
		return new IntValue(i);
	}

	@Override
	public boolean checkType(Context c) {
		return true;
	}

}
