package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.IntValue;
import dfatool.values.Value;

public class ModExpression extends BinaryExpression {

	public ModExpression(Expression lExp, Expression rExp) {
		super(lExp, rExp);
	}

	@Override
	public Value evaluate(Context c) {
		int i1 = ((IntValue) lExp.evaluate(c)).getValue();
		int i2 = ((IntValue) rExp.evaluate(c)).getValue();
		return new IntValue(mod(i1,i2));
	}
	
	public String toConcreteSyntax(){
		return lExp.toConcreteSyntax()+" % "+rExp.toConcreteSyntax();
	}
	
	private int mod(int i1, int i2){
		return (((i1 % i2) + i2) % i2);
	}
	
	public static void main(String[] args) {
//		System.out.println(mod(-1,2));
	}

}
