package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.Value;

public class ParenthesisExpression extends Expression{

	Expression exp;
	
	public ParenthesisExpression(Expression exp) {
		this.exp = exp;
	}
	
	@Override
	public Value evaluate(Context c) {
		return exp.evaluate(c);
	}

	@Override
	public boolean checkType(Context c) {
		return exp.checkType(c);
	}

	@Override
	public String toConcreteSyntax() {
		return "( " +exp.toConcreteSyntax()+ " )";
	}

}
