package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.IntValue;
import dfatool.values.Value;

public class PlusExpression extends BinaryExpression {

	public PlusExpression(Expression lExp, Expression rExp) {
		super(lExp, rExp);
		// TODO Auto-generated constructor stub
	}

	@Override
	public Value evaluate(Context c) {
		int i1 = ((IntValue) lExp.evaluate(c)).getValue();
		int i2 = ((IntValue) rExp.evaluate(c)).getValue();
		return new IntValue(i1+i2);
	}
	
	public String toConcreteSyntax(){
		return lExp.toConcreteSyntax()+" + "+rExp.toConcreteSyntax();
	}

}
