package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.IntValue;
import dfatool.values.ListValue;
import dfatool.values.SetValue;
import dfatool.values.Value;

public class Range extends ListExpression{
	private int ini,fin;

	public Range(int ini, int fin) {
		this.ini = ini;
		this.fin = fin;
		this.type = TypeConstants.RANGE;
	}

	public int getIni() {
		return ini;
	}

	public void setIni(int ini) {
		this.ini = ini;
	}

	public int getFin() {
		return fin;
	}

	public void setFin(int fin) {
		this.fin = fin;
	}

	@Override
	public Value evaluate(Context c) {
		ListValue s = new ListValue();
		for(int i = ini; i<=fin;i++) s.add(new IntValue(i));
		return s;
	}

	@Override
	public boolean checkType(Context c) {
		return fin > ini ;
	}
	
	public static void main(String[] args) {
		System.out.println(new Range(0, 12).evaluate(null).toString());
	}

	@Override
	public String toConcreteSyntax() {
		return "<"+ini+".."+fin+">";
	}
	
	
}
