package dfatool.expressions;

import dfatool.strategy.elements.Context;
import dfatool.values.ListValue;
import dfatool.values.SetValue;
import dfatool.values.Value;

public class SetExpression extends UnaryExpression{

	ListExpression expression;
	
	public SetExpression(ListExpression exp) {
		expression = exp;
	}
	
	@Override
	public Value evaluate(Context c) {
		ListValue list = (ListValue) this.expression.evaluate(c);
		SetValue set = new SetValue(list);
		return set;
	}

	@Override
	public boolean checkType(Context c) {
		return expression.checkType(c);
	}

	@Override
	public String toConcreteSyntax() {
		return "{" +expression.toConcreteSyntax().substring(1,expression.toConcreteSyntax().length()-1)+" }";
	}

	
	
}
