package dfatool.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import dfatool.strategy.elements.Context;
import dfatool.values.ListValue;
import dfatool.values.Value;

public class TupleExpression extends Expression{
	private List<Expression> t;
	
	public TupleExpression(List<Expression> list) {
		t = new ArrayList<Expression>(list);
	}
	
	public List<Expression> getList() {
		return t;

	}

	@Override
	public Value evaluate(Context c) {
		ListValue tp = new ListValue();
		for(Expression e: t) tp.add(e.evaluate(c)); 
		return tp;
	}

	@Override
	public boolean checkType(Context c) {
		boolean b = true;
		Iterator<Expression> it = t.iterator();
		while(it.hasNext() && b) b = b && it.next().checkType(c);
		return b;
	}

	@Override
	public String toConcreteSyntax() {
		String s = "";
		for(Expression e : t)
			s += e.toConcreteSyntax()+".";
		return s.substring(0,s.length()-1);
	}
	
//	public static void main(String[] args) {
//		Id id = new Id("nautico");
//		List<Expression> l = new ArrayList<Expression>();
//		l.add(id);
//		TupleExpression te = new TupleExpression(l);
//		Context c = new Context();
//		c.putVar("nautico", new Int(7));
//		System.out.println(te.evaluate(c));
//	}

}
