package dfatool.gui.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbenchActionConstants;

import dfatool.views.AtomInfo;
import dfatool.views.ChannelInfo;
import dfatool.views.DatatypeInfo;
import dfatool.views.DescriptionList;
import dfatool.views.EssentialComponentInfo;
import dfatool.views.EssentialComponentsList;
import dfatool.views.NetworkElementInfo;
import dfatool.views.NetworkList;
import dfatool.views.VarInfo;
import dfatool.views.graph.GraphView;

public class DFAToolPerspective implements IPerspectiveFactory{

	private IPageLayout factory;

	public DFAToolPerspective() {
		super();
	}

	public void createInitialLayout(IPageLayout factory) {
		this.factory = factory;
		addViews();
		addMenus();
	}
	

	private void addMenus() {
//		factory.addActionSet(actionSetId);
	}

	private void addViews() {
		// Creates the overall folder layout. 
		// Note that each new Folder uses a percentage of the remaining EditorArea.
		factory.setEditorAreaVisible(false);
		factory.addView(IPageLayout.ID_PROJECT_EXPLORER,IPageLayout.LEFT,0.25f,factory.getEditorArea());
		
		IFolderLayout editionPanel =
				factory.createFolder(
					"Edition",
					IPageLayout.BOTTOM,
					0.75f,
					factory.getEditorArea());
			editionPanel.addView(AtomInfo.ID);
			editionPanel.addView(ChannelInfo.ID);
			editionPanel.addView(VarInfo.ID);
			editionPanel.addView(DatatypeInfo.ID);
			editionPanel.addView(NetworkElementInfo.ID);
			editionPanel.addView(EssentialComponentInfo.ID);

		
		IFolderLayout descriptionPanel =
				factory.createFolder(
					"Description", //NON-NLS-1
					IPageLayout.RIGHT,
					0.75f,
					factory.getEditorArea());
			descriptionPanel.addView(DescriptionList.ID);
			descriptionPanel.addView(NetworkList.ID);
			descriptionPanel.addView(EssentialComponentsList.ID);
		
		
		factory.addView(GraphView.ID,IPageLayout.TOP,0.95f,factory.getEditorArea());
		
	}
}