package dfatool.handlers;

import java.io.IOException;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

import dfatool.strategy.elements.Configuration;
import dfatool.strategy.verification.Decomposition;
import dfatool.strategy.verification.Strategy;
import dfatool.views.DescriptionList;
import dfatool.views.graph.GraphView;

public class DecomposeHandler extends AbstractHandler{

	@Override
	public Object execute(ExecutionEvent event){
		try{
			Decomposition d = new Decomposition();
			d.decompose();
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			((GraphView) page.findView(GraphView.ID)).asyncRefresh();
		}catch (Exception e){
			try {
				MessageDialog.openError(HandlerUtil.getActiveWorkbenchWindowChecked(event).getShell(), "Error", e.getMessage());
			} catch (ExecutionException e1) {
				System.out.println("Cacilda!");
				e1.printStackTrace();
			}
			return null;
		}
		try {
			Strategy.verifyDeadlockFreedomOfNetwork(HandlerUtil.getActiveWorkbenchWindowChecked(event).getShell());
		} catch (ExecutionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
public static void main(String[] args) {
	Configuration.update(new Path("/home/pedino/Dropbox/PhD/MyPapers/SCP2015/runtime-DFA/RB30"));
	new Decomposition().generateDecompositionVerificationFiles();
	
}
}
