package dfatool.io;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.rowset.spi.XmlWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import dfatool.expressions.SetExpression;
import dfatool.parser.LanguageUtil;
import dfatool.strategy.elements.Atom;

public class AtomIOXML extends ElementIOXML<Atom> implements IAtomIO{
	
	public final static String BEHAVIOUR = "behaviour";
	public final static String ALPHABET = "alphabet";
	public final static String ATOM = "atom";
	
	public AtomIOXML(String filename){
		super(filename);
	}	

	@Override
	protected void writeElements(XMLStreamWriter writer) throws XMLStreamException {
		for(Atom at : map.values()){
			System.out.println(at.getName());
			writer.writeStartElement(ATOM);
			writer.writeAttribute("name", at.getName());
			writer.writeStartElement(BEHAVIOUR);
			writer.writeCharacters(at.getBehaviour());
			writer.writeEndElement();
			writer.writeStartElement(ALPHABET);
			writer.writeCharacters(at.getAlphabet().toString());
			writer.writeEndElement();
			writer.writeEndElement();
		}
		
	}

	@Override
	protected Map<String, Atom> readElements(XMLStreamReader reader) throws XMLStreamException {
		String name = null;
		String behaviour = null;
		String alphabetText = null;
		Map<String, Atom> map = new HashMap<String,Atom>();
		skipToNextStartElement(reader);
		skipToNextStartElement(reader);
		while(reader.hasNext()){
//			if (!skipToNextStartElement(reader)) break;
			name = reader.getAttributeValue(0);
			skipToNextStartElement(reader);
			System.out.println(reader.getLocalName());
			if (reader.getLocalName().equals(BEHAVIOUR)) 
				behaviour = readText(reader);
			System.out.println(behaviour);
			skipToNextStartElement(reader);
			if(reader.getLocalName().equals(ALPHABET)) 
				alphabetText = readText(reader);
//				SetExpression alphabet = parseAlphabet(alphabetText);
			Atom at = new Atom(name, behaviour, alphabetText);
			map.put(at.getName(), at);
			skipToNextStartElement(reader);
		}
		return map;
	}


//	private SetExpression parseAlphabet(String alphabetText) {
//		return (SetExpression) Parsing.parseString(alphabetText);
//	}



	public static void main(String[] args) {
		HashMap<String, Atom> map = new HashMap<String,Atom>();
		Atom a1 = new Atom("PHIL1","P = a -> STOP", "{a,b,c,d}");
		Atom a2 = new Atom("PHIL2","P = b -> STOP", "{a,b,f,g}");
		Atom a3 = new Atom("PHIL3","P = c -> STOP", "{a,b,h,j}");
		map.put(a1.getName(), a1);
		map.put(a2.getName(), a2);
		map.put(a3.getName(), a3);
		AtomIOXML io = null;
		io = new AtomIOXML("atoms.xml");
		io.updateElement(a1);
		io.updateElement(a2);
		io.updateElement(a3);
//		io.setAtoms(map);
//		io.writeToFile();
//		io.readFromFile();
		System.out.println("Here");
		for(Atom at: io.listElements()){
			System.out.println(at);
		}
	}
}
