package dfatool.parser;

import java.io.ByteArrayInputStream;

import dfatool.expressions.Expression;
import dfatool.strategy.elements.Configuration;
import dfatool.strategy.elements.Context;
import dfatool.values.IntValue;
import dfatool.values.Value;

public class LanguageUtil {
	
	public static Expression parseString(String s){
		try {
			return new ExpressionParser(new ByteArrayInputStream(s.getBytes())).ExpressionRule();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	public static Value evalWithId(Expression exp, Integer i){
		Context c = Configuration.getInstance().getContext();
		c.getVarMap().put("id", new IntValue(i));
		return exp.evaluate(c);
	}
	
//	public static Value evalWithBinding(Expression exp, String id, Integer i){
//		Context c = Context.createContext();
//		c.putVar(id, new IntValue(i));
//		c.putVar(name, v);
//		return exp.evaluate(c);
//	}
	
	public static Value parseAndEvalWithId(String s, Integer i){
		return evalWithId(parseString(s), i);
	}

	
	public static void main(String[] args) {
		Expression exp = LanguageUtil.parseString("< P.0, P.1 >");
		System.out.println(exp.toConcreteSyntax());
	}
}
