package dfatool.strategy.elements;

import java.net.URI;

import org.eclipse.core.runtime.IPath;

import patterns.Subject;

public class Configuration extends Subject{
	
	private Description description;
	private Context context;
	private Network network;
	private String projectRoot;
	private static Configuration instance;
	
	private Configuration(IPath projectPath) {
		description = new Description(projectPath);
		network = new Network(projectPath);
		context = new Context(description);
		projectRoot = projectPath.toString();
	}
	
	public static void update(IPath projectPath){
		instance = new Configuration(projectPath);
	}
	
	
	public static Configuration getInstance(){
		return instance;
	}
	
	public Context getContext() {
		return context;
	}
	
	public Network getNetwork() {
		return network;
	}
	
	public Description getDescription() {
		return description;
	}
	
	public String getProjectRoot() {
		return projectRoot;
	}
	
	
}
