package dfatool.strategy.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import patterns.Observer;
import patterns.Subject;
import dfatool.io.AtomIOXML;
import dfatool.io.ChannelIOXML;
import dfatool.io.DatatypeIOXML;
import dfatool.io.IAtomIO;
import dfatool.io.IChannelIO;
import dfatool.io.IDatatypeIO;
import dfatool.io.IVarIO;
import dfatool.io.VarIOXML;
import dfatool.values.SetValue;
import dfatool.views.InfoView;

public class Description{
	
	IDatatypeIO types;
	IChannelIO channels;
	IVarIO vars;
	IAtomIO atoms;
	
	public Description(IPath projectPath){
		types = new DatatypeIOXML(projectPath.append(ConfigurationConstants.DATATYPES_FILE).toString());
		channels = new ChannelIOXML(projectPath.append(ConfigurationConstants.CHANNELS_FILE).toString());
		vars = new VarIOXML(projectPath.append(ConfigurationConstants.VARS_FILE).toString());
		atoms = new AtomIOXML(projectPath.append(ConfigurationConstants.ATOMS_FILE).toString());
	}

	public void updateDatatype(Datatype t) {
		types.updateElement(t);
		Configuration.getInstance().getContext().putType(t);
	}
	
	public Datatype getDatatype(String name) {
		return types.getElement(name);
	}
	
	public void removeDatatype(Datatype t){
		types.removeElement(t);
		Configuration.getInstance().getContext().getTypeMap().remove(t.name);
	}

	public void updateChannel(Channel c) {
		channels.updateElement(c);
		Configuration.getInstance().getContext().putChannel(c);
	}
	
	public void removeChannel(Channel c){
		channels.removeElement(c);
		Configuration.getInstance().getContext().getChannelMap().remove(c.name);
	}
	
	public Channel getChannel(String name) {
		return channels.getElement(name);
	}

	public void updateVar(Var v) {
		vars.updateElement(v);
		Configuration.getInstance().getContext().putVar(v);
	}
	
	public void removeVar(Var t){
		vars.removeElement(t);
		Configuration.getInstance().getContext().getVarMap().remove(t.name);
	}
	
	public Var getVar(String name){
		return vars.getElement(name);
	}

	public void updateAtom(Atom a) {
		atoms.updateElement(a);
	}
	
	public void removeAtom(Atom a) {
		atoms.removeElement(a);
	}
	
	public Atom getAtom(String name) {
		return atoms.getElement(name);
	}
	
	public Collection<Atom> getAtoms(){
		return atoms.listElements();
	}
	
	public Collection<Channel> getChannels(){
		return channels.listElements();
	}
	
	public Collection<Var> getVars(){
		return vars.listElements();
	}
	
	public Collection<Datatype> getDatatypes(){
		return types.listElements();
	}
	
	public List<NamedElement> getList(){
		List<NamedElement> l = new ArrayList<NamedElement>();
		l.addAll(atoms.listElements());
		l.addAll(vars.listElements());
		l.addAll(types.listElements());
		l.addAll(channels.listElements());
		return l;
	}
	
	

}
