package dfatool.strategy.elements;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IPath;

import patterns.Subject;
import dfatool.io.INetworkIO;
import dfatool.io.NetworkIOXML;

public class Network{
	
	INetworkIO network;

	public Network(IPath projectPath){
		network = new NetworkIOXML(projectPath.append(ConfigurationConstants.NETWORK_FILE).toString());
	}

	
	public void updateElement(NetworkElement ne){
		network.updateElement(ne);
	}
	
	public void removeElement(NetworkElement ne){
		network.removeElement(new NetworkElement(ne.name, null));
	}
	
	public List<NetworkElement> getList(){
		return new ArrayList<NetworkElement>(network.listElements());
	}

	

}
