package dfatool.strategy.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import dfatool.values.Value;


public class NetworkNode implements INode{
	String atomName;
	int number;
	Set<Value> alphabet;
	List<INode> connections;
	List<NetworkNode> zestConnections;
	
	public NetworkNode(String atom, int number, Set<Value> alphabet) {
		this.atomName = atom;
		this.number = number;
		this.alphabet = alphabet;
		this.connections = new ArrayList<INode>();
		this.zestConnections = new ArrayList<NetworkNode>();
	}

	public String getAtomName() {
		return atomName;
	}
	


	public int getNumber() {
		return number;
	}



	public Set<Value> getAlphabet() {
		return alphabet;
	}

	
	public List<INode> getConnections() {
		return connections;
	}
	
	public List<NetworkNode> getZestConnections() {
		return zestConnections;
	}

	@Override
	public NodeIdentifier getIdentifier() {
		return new NodeIdentifier(atomName, number);
	}
	
	
	
}
